/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.adjustment.InstumentDetailsList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.instumentdetailslist',
	title : getFeeAndPaymentCommonTranslation('INSTUMENT_DETAILS'),
	store : 'feeandpayment.adjustment.FeeAdjustmentIntruments',
	border: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	selType:'checkboxmodel',
	selModel: {
		mode:'SINGLE',
		showHeaderCheckbox: false,
		 allowDeselect: true,
		 checkOnly : true,
		 renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			 var instrumentDate = record.get('instrumentDate');
			 if (instrumentDate <= new Date()) {
				 var baseCSSPrefix = Ext.baseCSSPrefix;
				 metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
				 return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
			 } else {
				 return '';
			 } 
		 }
	},
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	tbar: [{
		xtype: 'button',
		itemId: 'nextInstrumentBtn',
		disabled:true,
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.adjustment.FeeAdjustmentIntruments',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [{
		header : getCommonTranslation('INSTRUMENT_NO'),
		dataIndex : 'instrumentNo',
		flex : .1	 
	},{
		header : getCommonTranslation('INSTRUMENT_DATE'),
		dataIndex : 'instrumentDate',
		flex : .1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('AMOUNT'),
		dataIndex : 'instrumentAmount',
		flex : .1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('ALREADY_ADJUSTED_AMOUNT'),
		dataIndex : 'totalInstrumentAdjustedAmount',
		flex : .1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'totalInstrumentBalanceAmount',
		flex : .1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	}]
});