/**
 *  @author Priyanshi Sharma
 */
Ext.define('Academia.view.feeandpayment.adjustment.PaymentsListForReceiptSettlement', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.paymentslistforreceiptsettlement',
	title : getFeeAndPaymentCommonTranslation('PAYMENTS'),
	store : 'feeandpayment.adjustment.PaymentAdjustmentWithReceiptStore',
	border: true,
	refreshStoreData:true,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: false,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var balanceAmount = record.get("amountToBeAdjusted");
			if (balanceAmount>0) {
				var baseCSSPrefix = Ext.baseCSSPrefix;
				metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
				return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
			} else {
				return '';
			} 
		}
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	tbar: [{
		itemId: 'submitBtn',
		text:getCommonTranslation('SUBMIT'),
		tooltip: getCommonTranslation('SUBMIT')
	},],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('PAYMENT_VOUCHER_NO'),
		dataIndex : 'paymentVoucherNo',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('PAYMENT_DATE'),
		dataIndex : 'transactionDate',
		flex : 1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
		dataIndex : 'voucherMode',
		flex : 1	
	},{
		header : getFeeAndPaymentCommonTranslation('PAYMENT_AMOUNT'),
		dataIndex : 'amount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('ALREADY_ADJUST_AMOUNT'),
		dataIndex : 'totalAdjustmentAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'totalBalanceAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('AMOUNT_TO_BE_ADJUSTED'),
		dataIndex : 'amountToBeAdjusted',
		flex : 1,
		editing:true,
		itemId : 'amountToBeAdjusted',
		editor : {
			xtype:'numberfield',
			name: 'amountToBeAdjusted',
			itemId:'amountToBeAdjusted',
			mouseWheelEnabled:false,
			allowDecimals:true,
			enableKeyEvents:true,
			hideTrigger:true,
			minValue:0
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{
		header : getFeeAndPaymentCommonTranslation('VIEW_ADJUSTMENTS'),
		dataIndex : 'viewAdjustments',
		flex : 1,
		renderer:function(){
			return  '<a href="#">View</a>';
		}
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1
	}]
});