/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.adjustment.ReceiptsViewAdjustmentsList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.receiptsviewadjustmentslist',
	title : getFeeAndPaymentCommonTranslation('RECEIPTS'),
	store : 'feeandpayment.adjustment.ReceiptAdjustment',
	border: true,
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.adjustment.ReceiptAdjustment',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
		dataIndex : 'receiptNo',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('RECEIPT_DATE'),
		dataIndex : 'transactionDate',
		flex : 1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
		dataIndex : 'voucherMode',
		flex : 1	
	},{
		header : getFeeAndPaymentCommonTranslation('RECEIPT_AMOUNT'),
		dataIndex : 'amount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('ALREADY_ADJUST_AMOUNT'),
		dataIndex : 'totalAdjustedAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE'),
		dataIndex : 'totalBalanceAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('VIEW_ADJUSTMENTS'),
		dataIndex : 'viewAdjustments',
		flex : 1,
		renderer:function(){
			return  '<a href="#">View</a>';
		}
	}]
});