/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.controlAccount.ControlAccountList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.controlaccountlist',
	store : 'feeandpayment.controlAccount.ControlAccountList',
	title: getCommonTranslation('CONTROL_ACCOUNTS'),
	border: true,
	autoScroll: false,
	isGridConfigurable: true,
	enableColumnHide: false,
	reserveScrollbar:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'controlaccountstructure':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.controlAccount.ControlAccountList',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getCommonTranslation('ACCOUNT_CONFIGURATION_NAME'),
		dataIndex : 'accountConfig',
		flex : 1,
		renderer : function(value){
			 if(!isNullOrEmpty(value)){
				return value.code;
			}
		}
	},{
		header : getCommonTranslation('IAU'),
		dataIndex : 'organizationUnit',
		flex : 1,
		renderer : function(value){
			 if(!isNullOrEmpty(value)){
				return value.code;
			}
		}
	},{
		header : getCommonTranslation('CONTROL_ACCOUNT_KEY'),
		dataIndex : 'controlAccountKey',
		flex : 1
	},{
		header : getCommonTranslation('WHETHER_DEFAULT_CONTROL_ACCOUNT'),
		dataIndex : 'whetherDefaultControlAccount',
		flex : 1,
		renderer:function(value){
			if(value==true){
				return getCommonTranslation('YES');
			}else if(value==false){
				return getCommonTranslation('NO');
			}
		}
	}]
});