/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.controlAccount.ControlAccountWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.controlaccountwin',
	title:getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),
	frame: true,
	modal:true,
	method: 'POST',
	maxHeight: 600,
	autoScroll: true,
	width: 360,
	items: [{
		xtype: 'form',
		itemId:'controlaccountform',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:250
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'customcombobox',
			name: 'accountConfig',
			itemId:'accountConfig',
			fieldLabel: getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION_NAME'),
			store: 'feeandpayment.controlAccount.AccountConfigName',
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'organizationUnit',
			itemId:'organizationUnit',
			fieldLabel: getFeeAndPaymentCommonTranslation('IAU'),
			store: 'feeandpayment.accountingConfigurationMapping.IAUAcademyLocationWise',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			allowBlank: false,
			forceSelection:true
		},{	
			xtype: 'textfield',
			name: 'controlAccountKey',
			itemId: 'controlAccountKey',
			allowBlank: false,
			fieldLabel: getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT_KEY')
		},{
			xtype: 'checkboxfield',
			width: 'auto',
			itemId:'whetherDefaultControlAccountId',
			labelAlign: 'right',
			boxLabel: getFeeAndPaymentCommonTranslation('WHETHER_DEFAULT_CONTROL_ACCOUNT'),
			name: 'whetherDefaultControlAccount',
			checked:true,
			inputValue : true,
			uncheckedValue: false
		/*},{
			
			
			
			xtype: 'radiogroup',
			itemId:'whetherDefaultControlAccountId',
			width:'auto',
			columns: 2,
			vertical: true,
			fieldLabel: getFeeAndPaymentCommonTranslation('WHETHER_DEFAULT_CONTROL_ACCOUNT'),
			items:[
			       { boxLabel:getFeeAndPaymentCommonTranslation('YES'), name: 'whetherDefaultControlAccount', inputValue: true,checked:true},
			       { boxLabel:getFeeAndPaymentCommonTranslation('NO'), name: 'whetherDefaultControlAccount', inputValue: false}
			       ]*/
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getFeeAndPaymentCommonTranslation('SAVE'),
			formBind: true,
			itemId: 'SubmitBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('CANCEL'),
			ui: 'CustomBtnCancel',
			itemId: 'CancelBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
	}]
});
