/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.discounts.AddManageDiscount',{
	extend: 'Ext.form.FormPanel',
	alias: 'widget.addmanagediscount',
	title:getFeeAndPaymentCommonTranslation('ADD_DISCOUNT_ENTRY'),
	autoScroll: false,
	frame: true,
	method: 'POST',
	padding:32,
	standardSubmit: false,
	plugins : "formlabelrequired",
	items: [{
		xtype:'fieldcontainer',
		layout : 'vbox',
		defaults: {
			labelAlign:'top',
		},
		items: [{
			xtype:'fieldcontainer',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'userType',
				itemId: 'userType',
				store: 'feeandpayment.dashboardAndReports.DiscountFindAllUserTypeStore',
				fieldLabel: getCommonTranslation('USER_TYPE'),
				valueField: 'value',
				displayField: 'value',
				typeAhead: false,
				queryMode : 'local',
				allowBlank:false	
			},{
				xtype: 'customcombobox',
				name: 'student',
				itemId:'student',
				allowBlank:false,
				//width: 536,
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: 'feeandpayment.managebill.Student',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'applicant',
				itemId:'applicant',
				hidden:true,
				allowBlank:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_CODE_NAME'),
				store: 'feeandpayment.discount.DiscountApplicantStore',
				valueField: 'id',
				displayField: 'printName',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{printName}' +
						'</div>';
					}
				}
			}, {
				xtype: 'datefield',
				 name: 'appliedDate',
				 itemId:'appliedDateItemId',
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				 fieldLabel:getFeeAndPaymentCommonTranslation('APPLIED_DATE'),
//				 value: new Date(),
				 maxValue:new Date(),
				 allowBlank:false,
				 listeners: {
					 render: function(obj) {
						 obj = dateFormatRender(obj);						
						 obj.setValue(new Date());
					 }
				 }
			},]	
		},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getFeeAndPaymentCommonTranslation('APPLIED_BY'),
				name:'USER_NAME',
				itemId:'user_name',
				//store: 'criteriabuilder.userquicksearch.QuickSearchName',
	            store:Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName'),
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}, {
				xtype: 'customcombobox',
				name: 'discountType',
				itemId:'discountTypeItemId',
				allowBlank:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_TYPE'),
				store: 'feeandpayment.discount.DiscountTypeListByStudentStore',
				valueField: 'id',
				displayField: 'code',
				typeAhead:true,
				disabled:true,
				forceSelection:true
			}, {
				xtype: 'customcombobox',
				name: 'discountPercentage',
				itemId:'discountPercentageItemId',
				allowBlank:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_PERCENTAGE'),
				store: 'feeandpayment.discount.DiscountPercentageStore',
				valueField: 'id',
				displayField: 'code',
				typeAhead:true,
				disabled:true,
				forceSelection:true
			},{
				xtype: 'numberfield',
				name:'discountAmount',
				itemId:'discountAmount',
				hidden:true,
				minValue: 0,
				maxLength:10,
                allowDecimals:true,
                allowBlank: false,
	        	hideTrigger:true,
	        	mouseWheelEnabled:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_AMOUNT'),
			}]
		}]
		},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'datefield',
				name: 'applicableFrom',
				itemId: 'applicableFromItemId',
				allowBlank:false,
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				endDateField: 'validTillItemId',
				editable:false,
				fieldLabel:getFeeAndPaymentCommonTranslation('APPLICABLE_FROM'),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_DISCOUNT_SETTING_REST,
							async:true,
							method: 'GET',
							headers: {
								'Content-Type': 'application/json'
							},
							success: function(response) {
								if(!isNullOrEmpty(response.responseText)){
									var responseText  = Ext.decode(response.responseText);
									var minDate  = new Date();
									var days = responseText.backDateAllowInDays;
									minDate = new Date(minDate.getTime() - (days * 24 * 60 * 60 * 1000));
									obj.setMinValue(minDate);
								}
							}
						});
					}
				}
			},{
				xtype: 'datefield',
				name: 'validTill',
				itemId: 'validTillItemId',
	//			allowBlank:false,
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				startDateField: 'applicableFromItemId',
				editable:false,
				allowBlank:false,
				fieldLabel:getCommonTranslation('Valid_Till'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[/*{
				xtype: 'datefield',
				 name: 'appliedDate',
				 itemId:'appliedDateItemId',
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				 fieldLabel:getFeeAndPaymentCommonTranslation('APPLIED_DATE'),
//				 value: new Date(),
				 maxValue:new Date(),
				 allowBlank:false,
				 listeners: {
					 render: function(obj) {
						 obj = dateFormatRender(obj);						
						 obj.setValue(new Date());
					 }
				 }
			},*//*{
				xtype: 'customcombobox',
				fieldLabel: getFeeAndPaymentCommonTranslation('APPLIED_BY'),
				name:'USER_NAME',
				itemId:'user_name',
				//store: 'criteriabuilder.userquicksearch.QuickSearchName',
	            store:Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName'),
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},*/{
			xtype:'fieldcontainer',
			width:'auto',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('RESET'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				cls:'CustomBtnSubmitToolbaar',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});
