/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.discounts.DiscountFilters',{
	extend: 'Ext.form.FormPanel',
	alias: 'widget.discountfilters',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	cls:'customSearchPanel',
	items: [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'discountType',
			itemId:'discountTypeItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_TYPE'),
			store: 'feeandpayment.discount.DiscountMasterListStore',
			valueField: 'id',
			displayField: 'code',
			typeAhead:true,
			forceSelection:true
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256,
		},
		items:[{
			xtype: 'checkboxfield',
			width: 'auto',
			style:{marginTop:'20px'},
			itemId:'percentageItemId',
			labelAlign: 'left',
			boxLabel: getFeeAndPaymentCommonTranslation('WHETHER_PERCENTAGE'),
			name: 'percentage',
			inputValue : true,
			uncheckedValue: false 
		},{
			xtype: 'checkboxfield',
			width: 'auto',
			style:{marginTop:'20px'},
			itemId:'fixedItemId',
			labelAlign: 'left',
			boxLabel: getFeeAndPaymentCommonTranslation('WHETHER_FIXED'),
			name: 'fixed',
			inputValue : true,
			uncheckedValue: false 
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256,
		},
		items:[{
			xtype: 'checkboxfield',
			width: 'auto',
			style:{marginTop:'20px'},
			itemId:'adhocItemId',
			labelAlign: 'left',
			boxLabel: getFeeAndPaymentCommonTranslation('WHETHER_ADHOC'),
			name: 'adhoc',
			inputValue : true,
			uncheckedValue: false 
		},{
			xtype: 'checkboxfield',
			width: 'auto',
			style:{marginTop:'20px',marginLeft: '31px !important'},
			itemId:'standAloneItemId',
			labelAlign: 'left',
			boxLabel: getFeeAndPaymentCommonTranslation('WHETHER_STANDALONE'),
			name: 'standAlone',
			inputValue : true,
			uncheckedValue: false
		}]
	},{ 
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items:[]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});