/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.feeandpayment.discounts.uploaddownload.DiscountDownloadForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.discountdownloadform',
    frame: false,
    method: 'POST',
    standardSubmit: false,
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'discountTypeId',
            itemId: 'discountTypeItemId',
            fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_TYPE'),
            store: 'feeandpayment.discount.DiscountMasterListStore',
            valueField: 'id',
            displayField: 'code',
            allowBlank: false,
            typeAhead: true,
            editable: false,
            forceSelection: true
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
				xtype : 'multiselectcombofield',
				width: 536,
				name : 'manageDiscountAcademyLoc',
				itemId:'manageDiscountAcademyLocId',
				fieldLabel : getCommonTranslation('ACADEMY_LOCATION'),
				store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
				allowBlank : false,
				//height:58,
	  			cls:'commonAutoHeightMultiselectField',
	  			style :{
	  				//marginLeft: '6px'
	  			},
	  			//matchFieldWidth:true,
	  			maxLength:15000,
				queryParam: "qry",
				valueField : 'id',
				forceSelection : true,
				displayField : 'value',
				hideTrigger:false,
				typeAhead:true,
				//triggerAction: 'all',
				minChars:3,			
				emptyText: getCommonTranslation('ENTER_THREE_CHAR')				
			},
			/*{
            xtype: 'customcombobox',
            name: 'academyLocationId',
            itemId: 'academyLocationItemId',
            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            store: 'user.UserAcademyLocationStore',
            displayField: 'value',
            valueField: 'id',
            queryParam: 'qry',
            width: 536,
            typeAhead: true,
            forceSelection: true,
            hideTrigger: false,
            allowBlank: false,
            triggerAction: 'all',
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        },*/
		{
            xtype: 'customcombobox',
            name: 'intakeYearId',
            itemId: 'intakeYearItemId',
            fieldLabel: getCommonTranslation('INTAKE_YEAR'),
            store: 'common.IntakeYearStore',
            valueField: 'id',
            displayField: 'value',
            allowBlank: false,
            forceSelection: true,
            editable: false,
        }]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'programBatchSeatContainerItemId',
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            width: '100%',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                name: 'programId',
                itemId: 'programItemId',
                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                store: 'common.AssignedProgramStore',
                displayField: 'valueCode',
                valueField: 'id',
                queryParam: 'name',
                //width: 536,
                typeAhead: true,
                forceSelection: true,
                hideTrigger: false,
                allowBlank: true,
                disabled: true,
                triggerAction: 'all',
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                minChars: 3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{code} / {value}' +
                            '</div>';
                    }
                },
                listeners: {
                    /* render: function(combo) {
                     	var store = Ext.create('Academia.store.feeandpayment.ALProgramSearchCombo');
                         combo.bindStore(store);
                     },*/
                    select: function(obj, record) {
                        var programId = record[0].get("id");
                        var batch = obj.nextSibling();
                        var seatType = batch.nextSibling();

                        batch.setDisabled(false);
                        batch.reset();

                        seatType.setDisabled(true);
                        seatType.reset();

                        var store = batch.getStore();
                        store.proxy.extraParams = {
                            programIds: programId
                        };
                        store.load();
                    }
                }
            }, {
                xtype: 'customcombobox',
                name: 'batchId',
                itemId: 'batchItemId',
                fieldLabel: getPersonModuleTranslation('BATCH'),
                store: 'feeandpayment.ALProgramBatchSearchCombo',
                valueField: 'id',
                displayField: 'batch',
                disabled: true,
                editable: false,
                forceSelection: true,
                listeners: {
                    /* render: function(combo) {
                     	var store = Ext.create('Academia.store.feeandpayment.ALProgramSearchCombo');
                         combo.bindStore(store);
                     },*/
                    select: function(obj, record) {
                        var batchId = record[0].get("id");
                        var seatType = obj.nextSibling();

                        seatType.setDisabled(false);
                        seatType.reset();

                        var store = seatType.getStore();
                        store.proxy.extraParams = {
                            batchIds: batchId
                        };
                        store.load();
                    }
                }
            }, {
                xtype: 'customcombobox',
                name: 'seatTypeId',
                itemId: 'seatTypeItemId',
                fieldLabel: getCommonTranslation('SEAT_TYPE'),
                store: 'feeandpayment.ALProgramBatchSeatTypeList',
                valueField: 'programBatchSeatTypeId',
                displayField: 'seatName',
                disabled: true,
                editable: false,
                forceSelection: true
            }, {
                xtype: 'button',
                itemId: 'addFilterBtn',
                cls: 'CustomBodyBtnSettings',
                text: getCommonTranslation('ADDBUTTONTEXT'),
                tooltip: getCommonTranslation('ADD'),
                disabled: true,
                style: {
                    marginTop: '30px'
                }
            }]
        }]

    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
            itemId: 'downloadDiscountDownloadFormItemId',
            formBind: true,
            ui: 'CustomBtnSubmit'
        }, {
            xtype: 'button',
            itemId: 'resetBtnDiscountDownloadFormItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});