/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.finance.FinanceHoldBlockedStudentSearchForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.financeholdblockedstudentsearchform',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items: [{
			xtype:'hidden',
			name:'id'
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[
				//new 
				{
					xtype: 'customcombobox',
					name: 'academyLocationId',
					itemId: 'academyLocationId',
					fieldLabel: getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
					store:'feeandpayment.finance.FinanceBlokedStudentFilterAcademyLocationStore',
					displayField:'value',
					valueField:'id',
					typeAhead:true,
					forceSelection:true,
					hideTrigger:false,	    
					triggerAction: 'all',
					minChars:3,
					//queryParam:'programName',
					queryParam:'qry',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				
					
				},
				{
				xtype: 'customcombobox',
				name: 'programId',
				itemId: 'programId',
				fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM'),
				store:'facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore',
				displayField:'value',
				valueField:'id',
				typeAhead:true,
				forceSelection:true,
				hideTrigger:false,	    
				triggerAction: 'all',
				minChars:3,
				//queryParam:'programName',
				queryParam:'searchText',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				disabled:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				itemId:'batchId',
				store: 'enquiry.AcademicBatchStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'seatTypeId',
				disabled:true,
				itemId:'seatTypeId',
				fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
				//store: 'enquiry.ProgramBatchSeatTypeStore',
				store: 'common.SeatTypesByBatchId',
				valueField: 'seatTypeId',
				displayField: 'seatTypeName',
				typeAhead:true,
				forceSelection:true
			},{  
				xtype: 'customcombobox',
				name: 'holdType',
				itemId:'holdType',
				fieldLabel: getFeeAndPaymentCommonTranslation('HOLD_TYPE'),
				store: 'feeandpayment.finance.FinanceHoldTypeStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'student',
				itemId:'student',
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: 'feeandpayment.finance.FinanceBlokedStudentFilterStore',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			}]	
		},{
			xtype: 'panel',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			width: 'auto',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	});
