/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.managebill.BillDependentDetailsList', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.billdependentdetailslist',
	store : 'feeandpayment.managebill.BillDependentDetails',
	border: true,
	reserveScrollbar:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.managebill.BillDependentDetails',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('BILL_NO'),
		dataIndex : 'billNo',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('DEPENDENT_FEE_HEAD_NAME'),
		dataIndex : 'dependentFeeHeadName',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('THIRD_PARTY_NAME'),
		dataIndex : 'thirdPartyName',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('WHETHER_INCLUSIVE'),
		dataIndex : 'whetherInclusive',
		flex : 1,
		renderer:function(value){		
			if(value==true){
				return getFeeAndPaymentCommonTranslation('YES');
			}else{
				return getFeeAndPaymentCommonTranslation('NO');
			}
		}
	/*},{
		header : getFeeAndPaymentCommonTranslation('FEE_DEPENDENT_HEAD_AMOUNT'),
		dataIndex : 'feeDependentHeadAmount',
		flex : 1*/
	},{
		header : getFeeAndPaymentCommonTranslation('BILLING_DATE'),
		dataIndex : 'billingDate',
		flex : 1,
		hidden : true,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return dateRender(value);
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('AMOUNT_TYPE'),
		dataIndex : 'amountType',
		flex : 1,
		hidden : true
	/*},{
		header : getFeeAndPaymentCommonTranslation('CURRENCY_NAME'),
		dataIndex : 'currencyName',
		flex : 1,
		hidden : true*/
	},{
		header : getFeeAndPaymentCommonTranslation('BILL_DEPENDENT_FEE_AMOUNT'),
		dataIndex : 'billDependentFeeAmount',
		flex : 1,
		hidden : false
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_STAGE_FEE_HEAD_NAME'),
		dataIndex : 'feeStageFeeHeadName',
		flex : 1,
		hidden : true
	/*},{
		header : getFeeAndPaymentCommonTranslation('FEE_STAGE_HEAD_FEE_AMOUNT'),
		dataIndex : 'feeStageHeadFeeAmount',
		flex : 1,
		hidden : true*/
	}]
});