/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.managebill.BillServiceReceivedList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.billservicereceivedlist',
	store : 'feeandpayment.managebill.BillServiceReceived',
	border: true,
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.managebill.BillServiceReceived',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('SERVICE_RECEIVED_FOR_RADIO'),
		dataIndex : 'serviceReceived',
		flex : 0.2,
		renderer : function(value){
			if(value){
				return value.value;
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('AMOUNT'),
		dataIndex : 'feeAmount',
		flex : 0.8,
		renderer:function(value, metaData, record, row, col, store, gridView){
			return currencyRenderer(value,record.get("currencyId"));
		}
	}]
});