/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.managebill.RaiseBillForm',{
	//extend: 'Ext.form.FormPanel',
	extend:'Academia.view.common.IdGeneratorForm',
	formCode:'BillHeaderForm',
	alias: 'widget.raisebillform',
	title:getFeeAndPaymentCommonTranslation('BILL_HEADER'),
	autoScroll: false,
	frame: true,
	method: 'POST',
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	items: [{
		xtype: 'hidden',
		itemId:'id',
		name: 'id'
	},{
		xtype:'hidden',
		itemId:'billHeaderId',
		name:'billHeaderId'
	},{
		xtype:'fieldcontainer',
		width: '100%',
		//title:getFeeAndPaymentCommonTranslation('BILL_HEADER'),
		//frame : true,
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'textfield',
				name: 'billNo',
				/*allowBlank:true,
				emptyText: getCommonTranslation('ID_AUTOGENERATE'),
				readOnly:true,*/
				itemId:'billNo',
				allowBlank:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_NO'),
				emptyText: getCommonTranslation('ID_AUTOGENERATE'),
			},{
				xtype: 'customcombobox',
				name: 'raiseBillType',
				itemId:'raiseBillType',
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_TYPE'),
				store: 'feeandpayment.managebill.BillType',
				valueField: 'id',
				displayField: 'value',
				queryMode: 'local',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'raiseBillFor',
				itemId:'raiseBillFor',
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_FOR'),
				store: 'feeandpayment.managebill.BillFor',
				valueField: 'id',
				displayField: 'value',
				queryMode: 'local',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			},{
				xtype: 'checkboxfield',
	            name: 'inActiveStudent',
	            itemId:'inActiveStudentItemId',
	            labelAlign: 'right',
	            style:{
	            	marginTop:'25px !important'
	            },
	            boxLabel: getCommonTranslation('INACTIVE_STUDENT'),
			}]	
		},{
			xtype:'fieldcontainer',
			width: '100%',
			defaults: {
				labelAlign:'top'
			},
			items:[{
				xtype: 'radiogroup',
				itemId:'raiseBillCategory',
				name:'raiseBillCategoryName',
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_PAYABLE'),
				columns: 2,
				vertical: true,
				items: [
				        { boxLabel: getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_LABEL'), name: 'raiseBillCategory', inputValue:"BILL_RECEIVABLE",checked:true},
				        { boxLabel: getFeeAndPaymentCommonTranslation('BILL_PAYABLE_LABEL'), name: 'raiseBillCategory', inputValue:"BILL_PAYABLE"}
				        ]
			}]
		},{

	        xtype: 'customcombobox',
	        name: 'fnpBrandCampusName',
	        itemId: 'fnpBrandCampusItemId',
	        fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
	        valueField: 'id',
			displayField: 'value',
			store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
				width: 536,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			queryParam:'qry',
			typeAhead:false,
			hideTrigger:false,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
	        listConfig: {
	            listeners: {
	                beforeshow: function(picker) {
	                    picker.minWidth = picker.up('combobox').getSize().width;
	                }
	            },
	            loadingText: getCommonTranslation('SEARCHING'),
	            emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	            getInnerTpl: function() {
	                return '<div class="search-item">' +
	                    '{code}' +
	                    '</div>';
	            	}
	        	}
		},{
 
			xtype: 'customcombobox',
			name: 'thirdParty',
			itemId:'thirdParty',
			hidden:true,
			allowBlank:false,
			width: 536,
			fieldLabel: getFeeAndPaymentCommonTranslation('THIRD_PARTY'),
			store: 'feeandpayment.managebill.ThirdParties',
			valueField: 'id',
			displayField: 'printName',
			queryParam:'codeOrPrintName',
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			//minChars:3,
			typeAhead:false,
			forceSelection:true,
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'sponsors',
			itemId:'sponsors',
			hidden:true,
			allowBlank:false,
			width: 536,
			fieldLabel: getFeeAndPaymentCommonTranslation('SPONSOR'),
			store: 'feeandpayment.managebill.Sponsors',
			valueField: 'id',
			displayField: 'sponsorName',
			queryParam:'sponsorNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{sponsorshipCode}/{sponsorName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'applicant',
			itemId:'applicant',
			hidden:true,
			allowBlank:false,
			width: 536,
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT'),
			store: 'feeandpayment.managebill.Applicant',
			valueField: 'id',
			displayField: 'printName',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'user',
			itemId:'userId',
			allowBlank:false,
			hidden:true,
			width: 536,
			fieldLabel: getFeeAndPaymentCommonTranslation('USER'),
			store: 'feeandpayment.managebill.User',
			valueField: 'id',
			displayField: 'nameToBePrinted',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{nameToBePrinted}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			allowBlank:false,
			hidden:false,
			width: 536,
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.feeandpayment.managebill.ActiveStudentByALAndCode'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			queryCaching: false, 
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'scholarship',
			itemId:'scholarship',
			hidden:false,
			width: 536,
			fieldLabel: getFeeAndPaymentCommonTranslation('SCHOLARSHIP'),
			store: 'feeandpayment.managebill.ScholarshipSmartSearch',
			valueField: 'id',
			displayField: 'scholarshipName',
			queryParam:'scholarshipNameOrCode',
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			//minChars:3,
			allowBlank:false,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{scholarshipCode}/{scholarshipName}' +
					'</div>';
				}
			}
//		}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'scholarshipStudent',
				itemId:'scholarshipStudent',
				hidden:false,
				disabled:true,
				width: 536,
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: Ext.create('Academia.store.feeandpayment.managebill.ScholarshipStudent'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				queryCaching: false, 
				allowBlank:false,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
					}
				}
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'studenrtBatchSeat',
				itemId:'studenrtBatchSeatItemId',
				fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM_BATHC_SEAT_TYPE'),
				store: 'feeandpayment.ProgramBatchSeatTypeStore',
				valueField: 'id',
				displayField: 'value',
				readOnly:true,
				typeAhead:true,
				//hidden:true,
				forceSelection:true,
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'applicantBatchSeat',
				itemId:'applicantBatchSeatItemId',
				fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM_BATHC_SEAT_TYPE'),
				store: 'feeandpayment.ProgramBatchSeatTypeStoreForApplicant',
				valueField: 'id',
				displayField: 'value',
				readOnly:true,
				typeAhead:true,
				hidden:true,
				forceSelection:true,
				allowBlank:false
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'iau',
				itemId:'iau',
				fieldLabel: getFeeAndPaymentCommonTranslation('BILLING_IAU'),
				store: 'feeandpayment.ALUnit',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'currency',
				itemId:'currency',
				fieldLabel: getFeeAndPaymentCommonTranslation('CURRENCY'),
				store: 'feeandpayment.ManageBillFeeCurrencyStore',
				valueField: 'id',
				displayField: 'name',
				readOnly:true,
				typeAhead:true,
				allowBlank:false
			}]
		}]	
	},{

		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'datefield',
			name: 'billingDate',
			//vtype: 'daterange',
			//endDateField: 'dueDate',
			itemId:'billingDate',
			//--submitFormat: CONSTANTS.DATE_FORMAT,
//			value:new Date(),
			allowBlank: false,
			editable:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DATE'),
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_BILL_SETTING_REST,
						async:true,
						method: 'GET',
						headers: {
							'Content-Type': 'application/json'
						},
						success: function(response) {
							if(!isNullOrEmpty(response.responseText)){
								var responseText  = Ext.decode(response.responseText);
								var minDate  = new Date();
								var maxDate  = new Date();
								var backDays = responseText.backDateAllowInDays;
								var futureDays = responseText.futureDateAllowInDays;
								minDate = new Date(minDate.getTime() - (backDays * 24 * 60 * 60 * 1000));
								if(futureDays!=null)
								{
									maxDate = new Date(maxDate.getTime() + (futureDays * 24 * 60 * 60 * 1000));
									obj.setMaxValue(maxDate);
								}
								obj.setMinValue(minDate);

							}
						}
					});
				}
			}
		},{
			xtype: 'datefield',
			name: 'dueDate',
			itemId:'dueDate',
			allowBlank: false,
			//vtype: 'daterange',
			//startDateField: 'billingDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			//allowBlank: false,
		//	editable:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('DUE_DATE')
		}]
	},//manisha
	{	xtype:'panel',
		itemId: 'raiseBillPanel',
		style:{margin:'0px'},
		width: '100%',
		items:[{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'textfield',
			name: 'decisionNumber',
			itemId:'decisionNumber',
			allowBlank:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('DECISION_NUMBER'),
			hidden:true,

		},{
			xtype: 'datefield',
			name: 'dateOfDecision',
			itemId:'dateOfDecision',
			hidden:true,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			fieldLabel: getFeeAndPaymentCommonTranslation('DATE_OF_DECISION')
		}
		]}
	]}
	,{
		xtype: 'textfield',
		name: 'billStatus',
		readOnly:true,
		hidden:true,
		itemId:'billStatus',
		fieldLabel: getFeeAndPaymentCommonTranslation('BILL_STATUS')
	},{	
		xtype: 'textarea',
		width: 536,
		name: 'reasonForManualBill',
		itemId:'reasonForManualBill',
		fieldLabel: getFeeAndPaymentCommonTranslation('RESON_FOR_MANUAL_BILLING')
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		itemId:'allapprovers',
		hidden:true,
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'textfield',
			name: 'approver',
			readOnly:true,
			itemId:'approver',
			fieldLabel: getFeeAndPaymentCommonTranslation('APPROVER')
		},{
			xtype: 'datefield',
			name: 'approvalDate',
			itemId:'approvalDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			editable:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('APPROVED_ON')
		/*},{
			xtype: 'textfield',
			name: 'billStatus',
			readOnly:true,
			itemId:'billStatus',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_STATUS')*/
		}]	
	},{
		xtype:'fieldcontainer',
		width: '100%',
		itemId:'billamounts',
		hidden:true,
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'textfield',
			name: 'billAmount',
			readOnly:true,
			itemId:'billAmount',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_AMOUNT')
		},{
			xtype: 'textfield',
			name: 'billAmountPaid',
			readOnly:true,
			itemId:'billAmountPaid',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_AMOUNT_PAID')
		},{
			xtype: 'textfield',
			name: 'billAmountPending',
			readOnly:true,
			itemId:'billAmountPending',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_AMOUNT_PENDING')
		}]	
	},{
		xtype:'fieldcontainer',
		width: '100%',
		itemId:'iauamounts',
		hidden:true,
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'textfield',
			name: 'IAUAmount',
			readOnly:true,
			itemId:'IAUAmount',
			fieldLabel: getFeeAndPaymentCommonTranslation('IAU_AMOUNT')
		},{
			xtype: 'textfield',
			name: 'IAUAmountPending',
			readOnly:true,
			itemId:'IAUAmountPending',
			fieldLabel: getFeeAndPaymentCommonTranslation('IAU_AMOUNT_PENDING')
		}]	
},{
	xtype:'fieldcontainer',
	width:'auto',
	cls: 'form-fixed-footer',
	layout : {
		type : 'hbox'
	},
	items: [{
		xtype: 'button',
		text: getFeeAndPaymentCommonTranslation('SAVE'),
		formBind: true,
		itemId: 'SubmitBtn',
		ui: 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE,
	},{
		xtype: 'button',
		text: getFeeAndPaymentCommonTranslation('RESET'),
		ui: 'CustomBtnCancel',
		itemId: 'CancelBtn',
		scale: CONSTANTS.BUTTONSIZE
	}]
}]
});