/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.managebill.ScholarShipWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.scholarshipwindow',
	title:getFeeAndPaymentCommonTranslation('SCHOLARSHIP'),
	frame: true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		bodyPadding: '0 0 0 0',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			    xtype:'hidden',
			    name:'id'
		    },{
				xtype: 'customcombobox',
				name: 'scholarshipId',
				itemId:'scholarshipAwardee',
				fieldLabel: getFeeAndPaymentCommonTranslation('SCHOLARSHIP_RECEIVED'),
				store:'feeandpayment.managebill.ScholarshipAwardee',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				allowBlank:false,
				typeAhead:true
			},{
				xtype: 'numberfield',
				allowBlank:false,
				name: 'feeAmount',
				itemId:'feeAmount',
				readOnly:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('SCHOLARSHIP_AMOUNT')
			},{
				xtype: 'numberfield',
				name: 'IAUscholarshipAmount',
				itemId:'IAUscholarshipAmount',
				fieldLabel: getFeeAndPaymentCommonTranslation('IAU_SCHOLARSHIP_AMOUNT'),
				enforceMaxLength : true,
				hidden:true,
        	    minValue:0,
        	    maxLength: 10,
        	    minLength:10,
        	    hideTrigger:true,
        	    mouseWheelEnabled:false
		
		    },{
				xtype: 'fieldcontainer',
				width:'100%',
				cls:'windowBtnPos',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SAVE'),
					itemId: 'SubmitBtn',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
					formBind: true
				},{
					xtype: 'button',
					text: getCommonTranslation('CANCEL'),
					itemId: 'CancelBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]
		     }]
	    }]     
});