/**
 *  @author Amit G
 */
Ext.define('Academia.view.feeandpayment.payment.FeeOfflinePaymentDetailGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.feeofflinepaymentdetailgrid',
	store : 'feeandpayment.payment.FeeOfflinePaymentDetailGridStore',
	title: getFeeAndPaymentCommonTranslation('OFFFLINE_PAYMENT_PROOF_DETAIL'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.payment.FeeOfflinePaymentDetailGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('PROOF_NO'),
		dataIndex : 'proofno',
		flex:1
	},{
		header : getCommonTranslation('TOTAL_AMOUNT'),
		dataIndex : 'amount',
		flex:1
	},{
		header : getCommonTranslation('CREATED_ON'),
		dataIndex : 'createdOn',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'status',
		flex:1,
		renderer: function(value) {
			if(value == 'PENDING'){
				return 'Pending';
			}else if(value == 'APPROVED'){
				return 'Approved';
			}else if(value == 'REJECTED'){
				return 'Rejected';
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
		dataIndex : 'receiptNo',
		flex:1
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'noOfDocuments',
		flex:1,
		renderer : function(value){
			if(value>=1){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}

		}
	}]
});
