/**
 * @author Priyanshi sharma
 */
Ext.define('Academia.view.feeandpayment.payment.ManageDebitOrdersFilter', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.managedebitordersfilter',
	autoScroll: true,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'panel',
		width:'100%',
		cls:'customSearchPanel',
		items:[{
			xtype:'hidden',
			name:'id'
		},
		{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'debitOrderBrandCampus',
				itemId: 'debitOrderBrandCampus',
				fieldLabel: getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
				valueField: 'id',
				displayField: 'value',
				store:'common.AcademyLocationNameSeparated',
				queryParam: 'qry',
				width: 698,
				labelAlign:'top',
				triggerAction: 'all',
				minChars:3,
				allowBlank:false,
				typeAhead:true,
				forceSelection: true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			}]
		},
		{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype:'customcombobox',
				name: 'debitOrderDate',
				itemId: 'debitOrderDate',
				///store: 'feeandpayment.payment.DebitOrdersDateStore',
				fieldLabel: getFeeAndPaymentCommonTranslation('DEBIT_ORDER_DATE'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
				typeAhead: false,
				//queryMode : 'local',
				allowBlank : true,
				 listeners: {
                     render: function(combo) {
                         var store = Ext.create('Academia.store.feeandpayment.FeePayerDebitOrderDateStore');
                         combo.bindStore(store);
                     }
				 }
				
			},{
				xtype:'datefield',
				name:'paymentFromDate',
				itemId:'paymentFromDateId',
				editable: false,
				allowBlank:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_FROM_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
			endDateField: 'paymentTillDateId',
			vtype: 'daterange'
			},{
				xtype:'datefield',
				name:'paymentTillDate',
				itemId:'paymentTillDateId',
				editable: false,
				allowBlank:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_TILL_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				startDateField: 'paymentFromDateId',
            	vtype: 'daterange'
			},{
				xtype:'customcombobox',
				name: 'paymentPlan',
				itemId: 'paymentPlanId',
				//store: 'feeandpayment.payment.DebitOrdersPaymentPlanStore',
				store: 'feeandpayment.FindAllPaymentPlanStore',
				valueField: 'id',
				displayField: 'value',
				editable: false,
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN'),
				typeAhead: false,
				//queryMode : 'local',
				allowBlank : true,
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name:'program',
				store:Ext.create('Academia.store.common.ProgramByAcademyLocationStore'),
				itemId:'programId',
				fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'programName',
				triggerAction: '',
				minChars:3,
				allowBlank: true,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'intake',
				itemId: 'intakeId',
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				store:'enquiry.AcademicBatchStore',
				disabled:true,
				valueField: 'id',
				displayField: 'value',
				queryParam:'qry',
				typeAhead:true,
				editable: false,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
				name: 'seatType',
				itemId: 'seatTypeId',
				store:'enquiry.ProgramBatchSeatTypeStore',
				valueField: 'id',
				displayField: 'value',
				triggerAction: 'all',
				editable: false,
				disabled:true,
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'student',
				itemId:'student',
				width: 536,
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: Ext.create('Academia.store.feeandpayment.managebill.Student'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				fieldLabel: getFeeAndPaymentCommonTranslation('DEBIT_ORDER_STATUS'), //Seat Type
				name: 'debitOrderStatus',
				itemId: 'debitOrderStatusId',
				store:'feeandpayment.payment.DebitOrdersStatusStore',
				valueField: 'id',
				displayField: 'name',
				allowBlank:false,
				editable: false,
				value:'PENDING',
				hideTrigger:false,	 
				triggerAction: 'all',
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype:'numberfield',
				name:'minimumAmount',
				itemId:'minimumAmount',
				fieldLabel:getFeeAndPaymentCommonTranslation('MINIMUM_AMOUNT'),
				allowBlank:false,
				minValue:1,
				maxLength:13
			},{
				xtype:'numberfield',
				name:'maximumAmount',
				itemId:'maximumAmount',
				fieldLabel:getFeeAndPaymentCommonTranslation('MAXIMUM_AMOUNT'),
				minValue:1,
				maxLength:13
			}]
			},{
			xtype: 'fieldset',
			collapsible : true,
			collapsed: true,
			title: getCommonTranslation('MORE_FILTERS'),
			titleCollapse: true,
			defaults : {
				labelAlign:'top',
//				tdAttrs: { style: 'padding: 5px;' }
			},
			style: {
              	 marginTop: '33px!important'
             },
			items:[{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width: 256
				},
				items:[{
					xtype: 'customcombobox',
					name: 'feePayer',
					itemId:'feePayerId',
					fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PAYER'),
					store: 'feeandpayment.payment.DebitOrdersFeePayerStore',
					// store:Ext.create('Academia.store.student.report.StudentFeePayerReportFilterDropdownStore'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'feePayer',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							},
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					}
				},{
					xtype: 'customcombobox',
					name: 'accountNumber',
					itemId:'accountNumberId',
					fieldLabel: getFeeAndPaymentCommonTranslation('ACCOUNT_NO'),
					store: 'feeandpayment.payment.DebitOrdersAccountNumberStore',
					valueField: 'id',
					displayField: 'value',
					queryParam:'accountNumber',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					}
				}]
			},{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width: 256
				},
				
				items:[{
					xtype: 'customcombobox',
					name: 'bankName',
					itemId:'bankNameId',
					fieldLabel: getFeeAndPaymentCommonTranslation('BANK_NAME'),
					store: 'feeandpayment.payment.DebitOrdersBankNameStore',
					// store: Ext.create('Academia.store.feeandpayment.receipts.DrawnOnBank'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'bankName',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					}
				},{
					xtype: 'customcombobox',
					name: 'branchCode',
					itemId:'branchCode',
					fieldLabel: getFeeAndPaymentCommonTranslation('BRANCH_CODE'),
					store: 'feeandpayment.payment.DebitOrdersBranchNameStore',
					// store: Ext.create('Academia.store.personinfo.common.personalinfo.BankBranchCodeStore'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'branchName',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					}
				}]
			}]
         },{
			xtype: 'fieldcontainer',
			//style:{marginLeft:'-12px',marginBottom:'-5px'},
			width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getFeeAndPaymentCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getFeeAndPaymentCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	  },{
			xtype:'managedebitordersgrid',
			itemId:'managedebitordersgrid',
			width:'100%',
		}]
	});