/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.payment.ManageOfflinePaymentDetailForm', {   
	extend:'Academia.view.common.DynamicFieldForm',
	formCode:'ManageReceiptForm',
	alias : 'widget.manageofflinepaymentdetailform',
		
	method : 'POST',
	title:getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_DETAILS'),
	frame:true,
	standardSubmit : false,
	defaults: {
		labelAlign:'top'
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'panel',
		items:[{
			xtype:'hidden',
			name:'id'
	},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype:'textfield',
				fieldLabel:getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF_NO'),
				itemId:'offlinePaymentProofNo',
				emptyText: getCommonTranslation('ID_AUTOGENERATE'),
				name:'offlinePaymentProofNo',
				readOnly:true
			},{
				xtype: 'customcombobox',
				name: 'receivingCurrency',
				itemId:'receivingCurrency',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIVING_CURRENCY'),
				store: 'feeandpayment.FeeCurrencyStore',
				valueField: 'id',
				displayField: 'name',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			}]
		},{
			xtype:'panel',
			itemId: 'offlinePaymentheaderPanel',
			style:{margin:'0px'},
			width: '100%',
			items:[{
				xtype: 'fieldcontainer',
				width: '100%',
				layout: {
					type: 'hbox',
					align: 'bottom'
				},
				items: [{
					xtype: 'customcombobox',
					itemId: 'paymentMode',
					name: 'paymentMode',
					 width: 150,
					fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
					labelAlign: 'top',
					store: 'feeandpayment.FeePaymentMode',
					valueField: 'id',
					displayField: 'value',
					//typeAhead:true,
				    forceSelection:true,
					allowBlank: false
				}, {
					xtype:'textfield',
					enableKeyEvents : true,
					itemId: 'instrumentsNo',
					labelAlign: 'top',
					width: 130,
					name: 'instrumentsNo',
					maxLength: 40,
					allowBlank: false,
					fieldLabel: getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
					listeners:{
						keypress : function(e, t){
							try {
								if (window.event) {
									var charCode = window.event.keyCode;
								}else if (e) {
									var charCode = e.which;
								}else { return true; }

								if (charCode > 31 && (charCode < 48 || charCode > 57) && (charCode < 65 || charCode > 90) && (charCode < 97 || charCode > 122)) {
									return t.preventDefault();
								}
							}
							catch (err) {
								alert(err.Description);
							} 
						}
					}
				},{
					xtype:'datefield',
					fieldLabel:getFeeAndPaymentCommonTranslation('INSTRUMENT_DATE'),
					itemId:'instrumentDate',
					name:'instrumentDate',
					labelAlign: 'top',
					width: 130,
					allowBlank: false,
					maxValue:new Date(),
					listeners: {
						render: function(obj) {
							obj = dateFormatRender(obj);						
						}
					}
				},{
					xtype: 'numberfield',
					itemId: 'amount',
					fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT'),
					labelAlign: 'top',
					width: 130,
					name: 'amount',
					minValue: 0,
					maxLength:10,
                    allowDecimals:true,
                    allowBlank: false,
		        	hideTrigger:true,
		        	mouseWheelEnabled:false
				},{
					xtype: 'customcombobox',
					itemId: 'drawnOnBank',
					name: 'drawnOnBank',
					fieldLabel: getFeeAndPaymentCommonTranslation('DRAWN_ON_BANK'),
					labelAlign: 'top',
					width: '31%',
					store: 'feeandpayment.receipts.DrawnOnBank',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
 	        	    forceSelection:true,
					allowBlank: false      	  
				},{
					xtype: 'button',
					itemId: 'btnAddOfflinePaymentHeader',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					listeners:{
		   				   click:function(obj){
		   					   var frm = obj.up('manageofflinepaymentdetailform');
		   					  var getform = frm.getForm();	
		   					   getform.isValid();
		   					   if(getform.isValid() == true){
		   						frm.down('#SubmitBtn').setDisabled(false);  
		   					   }else{
		   						frm.down('#SubmitBtn').setDisabled(true);    
		   					   }
		   					   frm.doLayout();
		   				   }
		   			   }
				},{
					xtype:'hidden',
					name:'instrumentId'
				}] 
			}]
		},{
			xtype: 'feeofflinepaymentdocumentlistgrid',
			itemId:'feeofflinepaymentdocumentlistgridItemId',
			width: '31%',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1

		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('RESET'),
				itemId: 'btnReset',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getProgramandcourseTranslation('UPLOAD_DOCUMENT'),
				itemId: 'uploadDocument',
				ui: 'CustomBtnThird',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]}]
});