/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.payment.PaymentListForServiceReceived', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.paymentlistforservicereceived',
	store : 'feeandpayment.payment.PaymentForServiceReceived',
	title: getCommonTranslation('LIST_OF_PAYMENT'),
	isGridConfigurable: true,
	enableColumnHide: false,
	border: true,
	//autoScroll: true,
	style: {overflowX: 'auto', overflowY: 'hidden'},
	viewConfig : {
		getRowClass: function (record, rowIndex, rowParams, store) {
							if(record.get('academyName') == 'Total(In '+record.data.acadLocBaseCurrency+')'){
									 return (record.get('academyName') == 'Total(In '+record.data.acadLocBaseCurrency+')') ? 'gridPaymentGrid' : '';
				}
				else{
					 return (record.get('academyName') == 'Total') ? 'gridPaymentGrid' : '';
				}
	       },
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
        ftype: 'summary',
        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
    }],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.payment.PaymentForServiceReceived',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('CANCEL'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex : 2,
		/*summaryRenderer: function(value, summaryData, dataIndex) {
	          return getFeeAndPaymentCommonTranslation('TOTAL');
	      }*/
	},{
		header : getCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex : 1
	},{
		header : getCommonTranslation('USER_NAME'),
		dataIndex : 'userPrintName',
		flex : 1
	},{
		header : getCommonTranslation('PAYMENT_VOUCHER_NO'),
		dataIndex : 'paymentVoucherNo',
		flex : 1
	},{
    	 header : getCommonTranslation('VOUCHER_MODE'),
     	 dataIndex : 'voucherMode',
     	 flex : 1,
     	renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
	},{
		header : getCommonTranslation('SETTLEMENT_STATUS'),
		dataIndex : 'paymentStatus',
		flex : 1,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
     },{
    	 header : getCommonTranslation('PAYMENT_AMOUNT'),
     	 dataIndex : 'paymentAmount',
     	 flex : 1,
     	/*align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		}*/
     },{

  		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
  		dataIndex : 'currencyExchangeRate',
  		flex : 1.2,
  		
      },{
     	 header : getCommonTranslation('CONVERTED_AMOUNT'),
   		dataIndex : 'convertedAmount',
   		flex : 1.2,
       },
     {
    	 header : getCommonTranslation('PAYMENT_DATE'),
     	 dataIndex : 'transactionDate',
     	 flex : 1,
     	renderer:function(val){		
			return dateRender(val);
		}
     },{
    	 header : getCommonTranslation('ADJUSTMENT_DETAILS'),
     	 dataIndex : 'adjustmentDetails',
     	 flex : 1,
     	 renderer : function(value, metaData, record, row, col, store, gridView){
      		if(record.get('academyName') == 'Total(In '+record.data.acadLocBaseCurrency+')' || record.get('academyName') == 'Total'){
 				 return '';
 			}
 			else{
 				if(store.data.items[0].data.currencyId!=null){
 					return  '<a href="#">'+"View"+'</a>';
 				}
 			}
 			  
 		}
     	/*renderer : function(value){
			  return  '<a href="#">'+"View"+'</a>';
		}*/
     },{
    	 header : getCommonTranslation('INSTRUMENT_DETAILS'),
     	 dataIndex : 'instrumentDetails',
     	 flex : 1,
     	 renderer : function(value, metaData, record, row, col, store, gridView){
     	 if(record.data.voucherMode=="BANK"){
			  return  '<a href="#">'+"View"+'</a>';
   		 }else{
   			return value;
   		}}
     }]
});