/**
 * @author Rajkumar.Patidar 
 */

 
Ext.define('Academia.view.feeandpayment.payment.ReceiptAndPaymentGridWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.receiptandpaymentgridwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '70%',
	width: '70%',
	defaults:{
		width:'100%'
	},
	layout:'vbox',
	title:getFeeAndPaymentCommonTranslation('ADJUSTMENTS_DETAILS'),
	items: [{
		xtype: 'grid',
		store:'',
		frame: false,
		border:true,
		autoScroll: false,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		features: [{
	        ftype: 'summary',
	        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : '',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getFeeAndPaymentCommonTranslation('NUMBER'),
			dataIndex : 'no',
			flex : 1,
			summaryRenderer: function(value, summaryData, dataIndex) {
		          return getFeeAndPaymentCommonTranslation('TOTAL');
		      }
		}, {
			header : getFeeAndPaymentCommonTranslation('ADJUSTMENT_DATE'),
			dataIndex : 'adjustmentDate',
			flex : 1,
			renderer:function(val){
				if(!isNullOrEmpty(val)){
					return dateRender(val);
				}
			}
		},{
			header : getFeeAndPaymentCommonTranslation('FEE_ADJUSTMENT_AMOUNT'),
			dataIndex : 'adjustedAmount',
			flex : 1,
			//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			summaryType: 'sum',
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(record.get("currencyId"))){
					return currencyRenderer(value,record.get("currencyId"));
				}
			},
			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
				return  value;
			}
		},{
			header : getFeeAndPaymentCommonTranslation('DATE'),
			dataIndex : 'voucherDate',
			flex : 1,
			renderer:function(value){
				if(!isNullOrEmpty(value)){
					return dateRender(value);
				}
			}
		},{
			header : getFeeAndPaymentCommonTranslation('VOUCHER_TYPE'),
			dataIndex : 'voucherType',
			flex : 1,
			renderer:function(value){
				if(!isNullOrEmpty(value)){
					return getCommonTranslation(value);
				}
			}
		},{
			header : getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
			dataIndex : 'voucherMode',
			flex : 1,
			renderer:function(value){
				if(!isNullOrEmpty(value)){
					return getCommonTranslation(value);
				}
			}
		}] 	
	}]
});
