/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.paymentPlanEnrollment.PaymentPlanRequestsRejectedForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.paymentplanrequestsrejectedform',
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	items: [ {
		xtype : 'fieldcontainer',
		 layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            width: 256,
	            labelAlign: 'top'
	        },
		items : [ {
			xtype: 'hidden',
			name: 'paymentPlanId',
			itemId: 'paymentPlanRequestsRejected',
		},{
			xtype: 'customcombobox',
			name: 'program',
			itemId: 'programId',
			fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM'),
			store:Ext.create('Academia.store.feeandpayment.paymentPlanEnrollment.StoFnpProgramByPaymentPlanStore'),
			valueField: 'id',
			displayField: 'valueCode',
			typeAhead:true,
			forceSelection:true,
			hideTrigger:false,	 
			queryParam:'qry',
			triggerAction: 'all',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'batch',
			disabled:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
			itemId:'batchId',
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
		},{
			xtype: 'customcombobox',
			name: 'seatType',
			disabled:true,
			itemId:'seatTypeId',
			fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			store: 'enquiry.ProgramBatchSeatTypeStore',
			valueField: 'id',
			displayField: 'value'
		}]
	},{
    	xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchRequestsRejectedButtonId',
			buttonAlign : 'left',
			formBind: true,
			ui : 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetRequestsRejectedButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}]
});