/**
 *  @author Amit G
 */
Ext.define('Academia.view.feeandpayment.paymentTermDetailsViewgrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.paymenttermdetailsviewgrid',
	border: true,
	title:getPersonModuleTranslation('PAYMENT_TERMS'),
	store : 'personinfo.common.personalinfo.FeePayerCurrentPaymentTermEditGridStoreERP',
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns: [{
		hidden:true,
		dataIndex:'feePlanRuleId'
	},{
		header : getAdmissionTranslation('FEE_TYPE'),
		dataIndex : 'feePlanType',
		flex : 1	  
	},{
		header : getAdmissionTranslation('FEE_NAME'),
		dataIndex : 'feePlanName',
		flex : 1	  
	},{

		header:  getPersonModuleTranslation('PAYMENT_TERM_IN_SELECTION'),
		dataIndex: 'feeRuleNameOnlyForEditAndView',
		flex:1,
		sortable: false, 
		editor: {
            xtype: 'customcombobox',
            name: 'paymentTermCombo',
            itemId: 'paymentTermCombo',
            allowBlank:false,
            valueField: 'feePlanRuleName',
            displayField: 'feePlanRuleName',
            queryMode:'local',
    		listeners: {
                focus: function(combo) {
                	var grid = combo.up('grid');
                	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                    var store = Ext.create('Academia.store.personinfo.common.personalinfo.FeePayerPaymentTermSelectionComboStore');
                    combo.bindStore(store);
                    var comboStore =  selectedRecord.data.feePlanRules;
					 if(store.getRange()){
						 store.removeAll();	 
					 }
					 store.add(comboStore);
                },
                select:function(obj,record){
                	var grid = obj.up('grid')
                	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                	selectedRecord.set('feeRuleIdOnlyForEditAndView',record[0].data.feePlanRuleId);
                  
                }
                
            }
           
        },    
        renderer:function(value, rec, record, rowIndex, colIndex, store, view) {
        	
        	if(!isNullOrEmpty(record.data.feePlanRules) &&  !isNullOrEmpty(value))
        	{
        		return value;
        	} else {
        		meta.tdCls = 'gridInputCustomStyle';
        		return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
        	}                        
        }
	
	}],
	plugins: {
		ptype: 'cellediting',
		clicksToEdit: 1,

	},
	listeners: {
		beforeedit:function(editor, context){			
			var formWin =Ext.ComponentQuery.query('paymenttermdetailsview')[0];
			if(formWin.isView){
				context.grid.columns[3].getEditor().setReadOnly(true);
			}else{
				context.grid.columns[3].getEditor().setReadOnly(false);
			}
		}
	}
});