/**
 * @author Rajkumar.Patidar 
 */
Ext.define('Academia.view.feeandpayment.receipts.FeeHeadDetailsGridWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.feeheaddetailsgridwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '40%',
	width: '80%',
	frame: true,
	title:getFeeAndPaymentCommonTranslation('FEE_HEAD_DETAILS'),
	items : [/*{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			labelAlign:'top'
		},
		items: [{
			xtype:'displayfield',
			name:'sponsorCode',
			style:{marginLeft:'13px'},
			itemId:'sponsorCode',
			fieldLabel:getCommonTranslation('SPONSOR_CODE')
		},{
			xtype:'displayfield',
			name:'sponsorName',
			style:{marginLeft:'13px'},
			itemId:'sponsorName',
			fieldLabel:getCommonTranslation('SPONSOR_NAME')
		}]
	},*/{
			xtype: 'grid',
			store : 'feeandpayment.receipts.FeeHeadDetails',
			autoScroll: true,
			itemId : 'billHeaderGrid',
			border: true,
			viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},
			features: [{
				ftype: 'summary',
				showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
			}],
			dockedItems : [{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [{
					xtype: 'custompagingtoolbar',
					plugins:['pagesize'],
					store : 'feeandpayment.receipts.FeeHeadDetails',
					emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo : true
				}]
			}],
			columns: [{
				header : getFeeAndPaymentCommonTranslation('BILL_DATE'),
				dataIndex : 'billingDate',
				flex : 1,
				renderer: function(date) {
					return dateRender(date);
				}
			},{
				header : getFeeAndPaymentCommonTranslation('BILL_NO'),
				dataIndex : 'billNo',
				flex : 1,
				summaryRenderer: function(value, summaryData, dataIndex) {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				}
			},{
				header : getFeeAndPaymentCommonTranslation('FEE_ADJUSTMENT_AMOUNT'),
				dataIndex : 'feeAdjustedAmount',
				flex : 1,
				align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
				summaryType: 'sum',
				renderer:function(value, metaData, record, row, col, store, gridView){
					if(!isNullOrEmpty(record.get("currencyId"))){
						return currencyRenderer(value,record.get("currencyId"));
					}
				},
				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					return  value;
				}
			}/*,{
				header : getFeeAndPaymentCommonTranslation('RECEIPT_AMONT'),
				dataIndex : 'receiptAmount',
				flex : 1
			},{
				header : getFeeAndPaymentCommonTranslation('ALREADY_SETTLED_AMOUNT'),
				dataIndex : 'alreadySettledAmount',
				flex : 1
			},{
				header : getFeeAndPaymentCommonTranslation('BALANCE_AMOUNT'),
				dataIndex : 'balanceAmount',
				flex : 1
			}*/,{
				header : getFeeAndPaymentCommonTranslation('ADJUSTMENT_DATE'),
				dataIndex : 'adjustmentDate',
				flex : 1,
				renderer: function(date) {
					return dateRender(date);
				}
			}] 	

		}]
});
