/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.receipts.ReceiptHeaderForm',{
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.receiptheaderform',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
	items: [{
		  xtype:'fieldcontainer',
		  //xtype: 'idgeneratorformwin',
		  // itemId:'receiptheaderform',
		width: '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'multiselectcombofield',
            name: 'fnpMultiBrandCampusName',
            itemId: 'fnpMultiBrandCampusItemId',
            fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
            valueField: 'id',
			displayField: 'value',
			store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
  			width: 698,
  			height:58,
  			autoloadStore: false,
  			cls:'multiBrandCampusCls commonAutoHeightMultiselectField',
  			matchFieldWidth:true,
  			maxLength:15000,
  			typeAhead: true,
            allowBlank:false,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'billType',
			itemId:'billType',
			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_TYPE'),
			store:'feeandpayment.managebill.BillTypeSearch',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'billFor',
			itemId:'billFor',
			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_FORM'),
			store:'feeandpayment.managebill.BillForReceiptSearch',
			valueField: 'id',
			//displayField: 'value',
			displayField: 'code',
			queryMode: 'local',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'thirdParty',
			itemId:'thirdParty',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('THIRD_PARTIES'),
			store: 'feeandpayment.managebill.ThirdParties',
			valueField: 'id',
			displayField: 'firstName',
			queryParam:'codeOrPrintName',
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
			//minChars:3,
			typeAhead:false,
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{firstName} {lastName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'sponsors',
			itemId:'sponsors',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('SPONSOR'),
			//store: 'feeandpayment.managebill.Sponsors',
			store:'sponsorship.SponsorsListForSuspenseStore',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'sponsorNameOrCode',
			forceSelection:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{sponsorshipCode}/{sponsorName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'applicant',
			itemId:'applicant',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT'),
			store: Ext.create('Academia.store.feeandpayment.managebill.Applicant'),
			valueField: 'id',
			displayField: 'printName',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'user',
			itemId:'userId',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('USER'),
			store: 'feeandpayment.managebill.User',
			valueField: 'id',
			displayField: 'nameToBePrinted',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{nameToBePrinted}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			hidden:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.feeandpayment.managebill.StudentDetailsByNationalId'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			queryCaching: false, 
			forceSelection:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'vbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'scholarship',
			itemId:'scholarship',
			hidden:true,
			width: 536,
			fieldLabel: getFeeAndPaymentCommonTranslation('SCHOLARSHIP'),
			store: 'feeandpayment.managebill.ScholarshipSmartSearch',
			valueField: 'id',
			displayField: 'scholarshipName',
			queryParam:'scholarshipNameOrCode',
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			//minChars:3,			
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
				       beforeshow: function(picker) {
				         picker.minWidth = picker.up('combobox').getSize().width;
				       }
				     },
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{scholarshipCode}/{scholarshipName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'scholarshipStudent',
			itemId:'scholarshipStudent',
			hidden:true,
			disabled:true,
			width: 536,
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.feeandpayment.managebill.ScholarshipStudent'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			//allowBlank:false,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'paymentMode',
			itemId:'paymentMode',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
			store:'feeandpayment.FeePaymentModeForReceiptStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true 
		},{
			xtype: 'customcombobox',
			name: 'billNo',
			itemId:'billNo',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_NO'),
			store: 'feeandpayment.managebill.DependentBillId',
			valueField: 'id',
			displayField: 'value',
			queryParam:'billNo',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			queryCaching:false,
			minChars:3,
			forceSelection:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'receiptNo',
			itemId:'receiptNo',
			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
			store: 'feeandpayment.receipts.ReceiptNo',
			valueField: 'id',
			displayField: 'value',
			queryParam:'receiptNo',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			forceSelection:true,
			typeAhead:false,
			queryCaching:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
	            xtype: 'checkboxfield',
	            width: 'auto',
	            labelAlign: 'right',
	            itemId:'whetherDeleted',
	            boxLabel: getCommonTranslation('INCLUDE_CANCELED_RECIEPT_RECORDS'),
	            name: 'whetherDeleted',
	            inputValue : true
	        }]
    	},{ 
		xtype:'fieldset',
		title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		collapsible:true,
		collapsed:true,
		width:'100%',
        items:[{
        	xtype:'fieldcontainer',
        	layout:'hbox',
        	width: '100%',
        	defaults: {
        		labelAlign: 'top',
        		width: 256
        	},
        	items:[{
        		xtype: 'multiselectcombofield',
        		name: 'program',
        		style:{marginTop:'10px'},
        		width: 536,
        		itemId: 'program',
        		fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
        		//store:'program.ProgramGroupStore',
        		store:'common.ProgramByAcademyLocationStore',
        		displayField:'valueCode',
        		valueField:'id',
        		typeAhead:true,
        		forceSelection:true,
        		autoloadStore: false,
        		hidden : false,
        		maxLength:2000,
        		cls:'receiptHeaderMultiselect',
        		listConfig: {
        			listeners: {
        				beforeshow: function(picker) {
        					picker.minWidth = picker.up('combobox').getSize().width;
        				}
        			},
        			loadingText: getCommonTranslation('SEARCHING'),
        			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        			getInnerTpl: function() {
        				return '<div class="search-item">' +
        				'{code} / {value}' +
        				'</div>';
        			}
        		}
        	},{ 
        		xtype: 'multiselectcombofield',
        		name: 'batch',
        		width: 536,
        		itemId: 'batch',
        		style:{marginTop:'10px'},
        		fieldLabel: getCourseTxCommonTranslation('BATCH'),
        		store: 'program.programbatchdetail.BatchStore',
        		displayField:'value',
        		valueField:'id',
        		typeAhead:true,
        		forceSelection:true,
        		autoloadStore: false,
        		disabled:true,
        		hidden : false,
        		maxLength:2000,
        		cls:'receiptHeaderMultiselect'
        	}]
        },{
        		xtype:'fieldcontainer',
        		layout:'hbox',
        		width: '100%',
        		defaults: {
        			labelAlign: 'top',
        			width: 256
        		},
        		items:[{
        			xtype: 'multiselectcombofield',
        			name: 'section',
        			width: 536,
        			itemId: 'section',
        			fieldLabel: getCourseTxCommonTranslation('SECTION'),
        			store:'coursetransaction.sectionmanagement.SectionMultiSelect',
        			displayField:'value',
        			valueField:'id',
        			typeAhead:true,
        			forceSelection:true,
        			autoloadStore: false,
        			disabled:true,
        			hidden : false,
        			maxLength:2000,
        			cls:'receiptHeaderMultiselect'
        		},{
        			xtype: 'customcombobox',
        			name: 'generationType',
        			itemId:'generationType',
        			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_GENERATION_TYPE'),
        			store:'feeandpayment.receipts.BillGenerationType',
        			valueField: 'id',
        			displayField: 'value',
        			typeAhead:true,
        			forceSelection:true
        		},{
        			xtype: 'customcombobox',
        			name: 'receiptType',
        			itemId:'receiptType',
        			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_MODE'),
        			store:'feeandpayment.receipts.ReceiptType',
        			valueField: 'id',
        			displayField: 'value',
        			typeAhead:true,
        			forceSelection:true
        		}]
        	},{ 
        		xtype:'fieldcontainer',
        		layout:'hbox',
        		width:'100%',
        		defaults: {
        			labelAlign: 'top',
        			width: 256
        		},
        		items:[{
        			xtype: 'customcombobox',
        			name: 'receiptCurrency',
        			itemId:'receiptCurrency',
        			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_CURRENCY'),
        			store:'feeandpayment.FeeCurrencyStore',
        			valueField: 'id',
        			displayField: 'name',
        			typeAhead:true,
        			forceSelection:true
        		}, {
        			xtype: 'customcombobox',
        			name: 'billStatus',
        			itemId:'billStatus',
        			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_STATUS'),
        			store:'feeandpayment.managebill.BillStatus',
        			valueField: 'id',
        			displayField: 'value',
        			typeAhead:true,
        			forceSelection:true
        		},{
        			xtype: 'customcombobox',
        			name: 'receiptStatus',
        			itemId:'receiptStatus',
        			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_STATUS'),
        			store:'feeandpayment.receipts.ReceiptStatus',
        			valueField: 'id',
        			displayField: 'value',
        			typeAhead:true,
        			forceSelection:true
        		},{
        			xtype: 'datefield',
        			name: 'billDateFrom',
        			itemId:'billDateFrom',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat: CONSTANTS.DATE_FORMAT,
        			editable:false,
        			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DATE_FROM')
        		}]
        	},{
        		xtype:'fieldcontainer',
        		layout:'hbox',
        		width:'100%',
        		defaults: {
        			labelAlign: 'top',
        			width: 256
        		},
        		items:[{
        			xtype: 'datefield',
        			name: 'billDateTill',
        			itemId:'billDateTill',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat: CONSTANTS.DATE_FORMAT,
        			editable:false,
        			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DATE_TILL')
        		},{
        			xtype: 'datefield',
        			name: 'billDueDateFrom',
        			itemId:'billDueDateFrom',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat: CONSTANTS.DATE_FORMAT,
        			editable:false,
        			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DUE_DATE_FROM')
        		}, {
        			xtype: 'datefield',
        			name: 'billDueDateTill',
        			itemId:'billDueDateTill',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat: CONSTANTS.DATE_FORMAT,
        			editable:false,
        			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DUE_DATE_TILL')
        		},{
        			xtype: 'datefield',
        			name: 'receiptDateFrom',
        			itemId:'receiptDateFrom',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat: CONSTANTS.DATE_FORMAT,
        			editable:false,
        			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_DATE_FROM')
        		}]
        	},{
        		xtype:'fieldcontainer',
        		layout:'hbox',
        		width:'100%',
        		defaults: {
        			labelAlign: 'top',
        			width: 256
        		},
        		items:[{
        			xtype: 'datefield',
        			name: 'receiptDateTo',
        			itemId:'receiptDateTo',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat: CONSTANTS.DATE_FORMAT,
        			editable:false,
        			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_DATE_TO')
        		},{
        			xtype: 'customcombobox',
        			name: 'voucherMode',
        			itemId:'voucherMode',
        			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
        			store:'feeandpayment.payment.VoucherMode',
        			valueField: 'id',
        			displayField: 'value',
        			typeAhead:true,
        			forceSelection:true
        		},{
        			xtype: 'customcombobox',
        			name: 'bankId',
        			itemId:'bankId',
        			fieldLabel: getFeeAndPaymentCommonTranslation('OUR_BANK_ACCOUNT'),
        			store:'feeandpayment.receipts.DrawnOnBankStore',
        			valueField: 'id',
        			displayField: 'value',
        			typeAhead:true,
        			forceSelection:true
        		}, {
        			xtype: 'multiselectcombofield',
        			name: 'costCentre',
        			itemId:'costCentre',
        			fieldLabel: getFeeAndPaymentCommonTranslation('COST_CENTER'),
        			store: 'feeandpayment.receipts.CostCentreReceipt',  
        			valueField:'id',
        			displayField:'value',
        			typeAhead:true,
        			forceSelection:true,
        			autoloadStore: false,
        			hidden : false,
        			maxLength:2000,
        			cls:'receiptHeaderMultiselect'
        		}]
        	}, {
        		xtype:'fieldcontainer',
        		items: [{
        			xtype: 'checkboxfield',
        			width: 'auto',
        			itemId:'inactiveStudentId',
        			boxLabel: getFeeAndPaymentCommonTranslation('ONLY_INACTIVE_STUDENTS'),
        			name: 'inactiveStudent',
        			inputValue : true
        		}]
        	}]
        },{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			ui: 'CustomBtnSubmit',
			formBind: true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
