/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.receipts.ReceiptHeaderListForThirdParty', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.receiptheaderlistforthirdparty',
	store : 'feeandpayment.receipts.ReceiptHeaderForThirdParty',
	border: true,
	title: getCommonTranslation('LIST_OF_RECEIPT'),
	autoScroll: false,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
//	style: {overflowX: 'auto', overflowY: 'hidden'},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.receipts.ReceiptHeaderForThirdParty',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
 },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},'->',{
		xtype: 'button',
		itemId: 'btnPrint',
		disabled:true,
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('PRINT_RECORD')
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('PROGRAM'),
		dataIndex : 'programPrintName',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('THIRD_PARTY_NAME'),
		dataIndex : 'feeThirdPatryName',
		flex : 1
	},{
    	header : getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
 		dataIndex : 'receiptNo',
 		flex : 1	 
     },{
    	 header : getFeeAndPaymentCommonTranslation('RECEIPT_MODE'),
    	 dataIndex : 'receiptType',
     	 flex : 1,
     	renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
     },{
    	 header : getFeeAndPaymentCommonTranslation('SETTLEMENT_STATUS'),
    	 dataIndex : 'status',
     	 flex : 1,
     	renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
     },{

    		header : getFeeAndPaymentCommonTranslation('CURRENCY_EXCHANGE_RATE'),
    		dataIndex : 'currencyExchangeRate',
    		flex : 1.2,
    		
      },{
       	 header : getFeeAndPaymentCommonTranslation('CONVERTED_AMOUNT'),
     		dataIndex : 'convertedAmount',
     		flex : 1.2,
       },{
		header : getHostelTranslation('CANCELLATION_REASON'),
		dataIndex : 'cancellationNarration',
		flex : 2,
		hidden:true
	},{
    	 header : getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
     	 dataIndex : 'paymentModeName',
     	 flex : 1
     },{
    	 header : getFeeAndPaymentCommonTranslation('RECEIPT_CURRENCY'),
     	 dataIndex : 'currencyName',
     	 flex : 1
     },{
    	 header : getFeeAndPaymentCommonTranslation('ADJUSTMENT_DETAILS'),
     	 dataIndex : 'adjustmentDetails',
     	 flex : 1,
     	renderer : function(value){
			  return  '<a href="#">'+"View"+'</a>';
		}
     },{
    	 header : getFeeAndPaymentCommonTranslation('INSTRUMENT_DETAILS'),
     	 dataIndex : 'instrumentDetails',
     	 flex : 1,
     	 renderer : function(value, metaData, record, row, col, store, gridView){
     	 if(record.data.voucherMode=="BANK"){
			  return  '<a href="#">'+"View"+'</a>';
   		 }else{
   			return value;
   		}}
     }]
});