/**
 * @author Deepak Nigam
 */
Ext.define('Academia.view.feeandpayment.reports.ApplicantDiscountReportGrid',{
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.applicantdiscountreportgrid',
	store:'feeandpayment.reports.ApplicantDiscountReportStore',
	title: getCommonTranslation('APPLICANT_DISCOUNT_REPORT'),
	cls:'centerAlignTitle',
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.reports.ApplicantDiscountReportStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns:[{
		header : getCommonTranslation('APPLICANT_ID'),
		dataIndex : 'applicationCode',
		flex:1,
		sortable:true,
		renderer:function(value){
			return '<a href=#>'+value+'</a>'
		},
		/*summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}*/
		summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
			if(store.data.items[0].data.conversionType == "AL" || store.data.items[0].data.conversionType == "ORG") {
			// a = currencyRenderer('',store.data.items[0].data.acadLocBaseCurrencyId).split(" ");
				return getFeeAndPaymentCommonTranslation('Total (In ' + store.data.items[0].data.currencyName +')');
			}
			else {
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
		}
	},{
		header : getCommonTranslation('APPLICANT_NAME'),
		dataIndex : 'printName',
		flex:1
	},{
		header : getCommonTranslation('FATHER_NAME'),
		dataIndex : 'fatherName',
		flex:1,
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1,
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1,
	},{

		header : getCommonTranslation('FEE_HEAD_GROUP'),
		dataIndex : 'groupingFeeHeadName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHeadName',
		flex:1,
	},{

		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE_DETAIL'),
		dataIndex : 'currencyExchangeRate',
		flex:1.0,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		/*renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},*/
	},{
		header : getCommonTranslation('FEE_AMOUNT'),
		dataIndex : 'billAmount',
		flex:1.8,
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'EX'){
				return currencyRenderer(value, store.data.items[0].data.currencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('CONVERTED_FEE_AMOUNT'),
		dataIndex : 'convertedInvoiceAmount',
		flex:1.0,
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
				return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('STUDENT_DISCOUNT_TYPE'),
		dataIndex : 'discountType',
		flex:1,
		renderer : function(value){
			if(!isNullOrEmpty(value)) return getCommonTranslation(value);
		}
	},{
		header : getCommonTranslation('DISCOUNT_CODE'),
		dataIndex : 'discountCode',
		flex:1,
	},{
		header : getCommonTranslation('DISCOUNT_AMOUNT'),
		dataIndex : 'discountAmount',
		flex:1.8,
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return '<a href=#>'+currencyRenderer(value,record.get("currencyId"))+'</a>';
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'EX'){
				return currencyRenderer(value, store.data.items[0].data.currencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('CONVERTED_DISCOUNT_AMOUNT'),
		dataIndex : 'convertedDiscountAmount',
		flex:1.0,
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
				return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
			}
			else {
				return '';
			}
		}
	},{
		header : getCommonTranslation('DISCOUNT_REMARK'),
		dataIndex : 'discountRemark',
		flex:1,
	},{
		header : getCommonTranslation('ADDRESS'),
		dataIndex : 'address',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('EMAIL_ID'),
		dataIndex : 'emailId',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('MOBILE_NUMBER'),
		dataIndex : 'mobileNo',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'personFirstName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'personMiddleName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'personLastName',
		flex:1,
		hidden:true
	}]

});
