/**
 * @author Ranga
 */
Ext.define('Academia.view.feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportGrid', {
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.applicantfeeheadwisecollectionreportgrid',
	store : 'feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportStore',
	title : getFeeAndPaymentCommonTranslation('APPLICANT_FEE_HEAD_WISE_COLLECTION_REPORT'),
	cls:'centerAlignTitle',
	border : true,
	autoScroll : false,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW  
	}],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins : [ 'pagesize' ],
			store : 'feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportStore',
			emptyMsg : getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	} ],
	initComponent : function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
					columns : [{
						header : getCommonTranslation('FEE_HEAD_GROUP'),
						dataIndex : 'groupingFeeHeadName',
						flex:1,
						hidden:true
					},{
								header : getCommonTranslation('FEE_HEADS'),
								dataIndex : 'feeHeadName',
								flex : 1,
								/*summaryRenderer : function(value, summaryData,
										dataIndex) {
									return getFeeAndPaymentCommonTranslation('TOTAL');
								}*/
								summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
									if(store.data.items[0].data.conversionType == "AL" || store.data.items[0].data.conversionType == "ORG") {
									// a = currencyRenderer('',store.data.items[0].data.acadLocBaseCurrencyId).split(" ");
										return getFeeAndPaymentCommonTranslation('Total (In ' + store.data.items[0].data.currencyName +')');
									}
									else {
										return getFeeAndPaymentCommonTranslation('TOTAL');
									}
								}
							},{
								header : getCommonTranslation('APPLICANT_COUNT'),
								dataIndex : 'applicantCount',
								flex : 1,
								renderer : function(value, meta, record) {
									if (!isNullOrEmpty(value)) {
										if (record.data.feeHeadId == 0) {
											return value;
										} else {
											return '<a href=#>' + value
													+ '</a>'
										}
									}
								}
							},{
								header : getCommonTranslation('TOTAL_AMNT'),
								dataIndex : 'totalBillAmount',
								flex : 1.8,
								summaryType : 'sum',
								align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
								renderer : function(value, metaData, record,
										row, col, store, gridView) {
									if (!isNullOrEmpty(value)) {
										return currencyRenderer(value, record
												.get("currencyId"));
									}
								},
								 summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
										if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG' || store.data.items[0].data.conversionType == 'EX'){
											return currencyRenderer(value,store.data.items[0].data.currencyId);
										}
										else {
											return Ext.util.Format.number(parseFloat(value), '0,000.00');
										}
									}
								
							},{
								header : getCommonTranslation('BILL_AMOUNT_PAID'),
								dataIndex : 'settledAmount',
								flex : 1.8,
								summaryType : 'sum',
								align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
								renderer : function(value, metaData, record,
										row, col, store, gridView) {
									if (!isNullOrEmpty(value)) {
										return currencyRenderer(value, record
												.get("currencyId"));
									}
								},
								 summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
										if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG' || store.data.items[0].data.conversionType == 'EX'){
											return currencyRenderer(value,store.data.items[0].data.currencyId);
										}
										else {
											return Ext.util.Format.number(parseFloat(value), '0,000.00');
										}
									}
							},{
								header : getCommonTranslation('OUTSTANDING_AMOUNT'),
								dataIndex : 'totalOutstandingAmount',
								flex : 1.8,
								summaryType : 'sum',
								align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
								renderer : function(value, metaData, record,
										row, col, store, gridView) {
									if (!isNullOrEmpty(value)) {
										return currencyRenderer(value, record
												.get("currencyId"));
									}
								},
								 summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
										if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG' || store.data.items[0].data.conversionType == 'EX'){
											return currencyRenderer(value,store.data.items[0].data.currencyId);
										}
										else {
											return Ext.util.Format.number(parseFloat(value), '0,000.00');
										}
									}
							}]

				});
