/**
 * @author Anand Verma
 */
Ext.define('Academia.view.feeandpayment.reports.ApplicantFeeReportForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.applicantfeereportform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
				labelAlign:'top',
				width: 256
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype:'customcombobox',
			name:'intakeyear',
			itemId:'intakeyear',
			fieldLabel: getFeeAndPaymentCommonTranslation('INTAKE_YEAR'),
			store:Ext.create('Academia.store.common.IntakeYearStore'),
			valueField:'id',
			displayField:'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype:'customcombobox',
			name:'feePlanType',
			itemId:'feePlanType',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
			store:'feeandpayment.FeePlanTypeStore',
			valueField:'id',
			displayField:'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype:'customcombobox',
			name:'applicantId',
			itemId:'applicantId',
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_CODE_NAME'),
			store:'feeandpayment.reports.ApplicantIntake',
			valueField:'id',
			displayField:'valueCode',
			typeAhead:false,
			forceSelection:false,
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			//allowBlank : false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{value}' +
					'</div>';
				}
			}
		},
		/*{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			width: 536,
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_NAME'),
			store: 'feeandpayment.reports.Student',
			valueField: 'id',
			displayField: 'studentName',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			//allowBlank : false,
			listConfig: {
			listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		}*/]
	},{
		xtype:'fieldset',
		title: getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		listeners:{
			expand:function(cmp){
				Ext.defer(function(){
					cmp.up('studentfeereportfinalstructure').doLayout();
					cmp.up('studentfeereportfinalstructure').updateLayout();
				},100);
				
			}
		},
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top',
				/*//xtype: 'numberfield',
				hideTrigger:true,
				mouseWheelEnabled:false,
				//allowDecimals:false,
				//allowExponential:false
*/			},
		items:[
		       {
		    	   xtype:'customcombobox',
		    	   name:'programId',
		    	   itemId:'programId',
		    	   fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    	   store:Ext.create('Academia.store.feeandpayment.reports.ProgramByApplicantIdAndIntake'),
		    	   displayField:'valueCode',
		    	   valueField:'id',
		    	   typeAhead:true,
		    	   forceSelection:true,
		    	   hideTrigger:false,
		    	   triggerAction: 'all',
		    	   minChars:3,
		    	   queryParam:'programName',
		    	   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    	   listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{code} / {value}'  +
			                    '</div>';
			                }
			            }
			   },{
				   xtype: 'customcombobox',
					name: 'batchId',
					disabled:true,
					fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
					itemId:'batchId',
					store: Ext.create('Academia.store.feeandpayment.reports.ApplicantBatchByProgramId'),
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				},
				{
					xtype: 'customcombobox',
					name: 'seatTypeId',
					disabled:true,
					itemId:'seatTypeId',
					fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
					store: Ext.create('Academia.store.feeandpayment.reports.ApplicantSeatTypeByBatch'),
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				}
		       
		       ]
	},
	{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[/*{
			xtype: 'customcombobox',
			name: 'period',
			itemId : 'periodId',
			fieldLabel: getCommonTranslation('PERIOD'),
			store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField : 'value',
			valueField : 'id',
			//allowBlank: false,
			disabled : true
		},*/{
			xtype: 'customcombobox',
			name: 'feePlan',
			itemId:'feePlan',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_NAME'),
			store: 'feeandpayment.reports.StudentFeePlanReportStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			disabled:true
		},{
            xtype: 'checkboxfield',
            width: 'auto',
            style:{
            	marginTop:'25px'
            },
			width: 256,
            labelAlign: 'right',
            itemId:'whetherApplicantId',
            boxLabel: getCommonTranslation('ONLY_APPLICANT'),
            name: 'whetherApplicant',
            inputValue : true
        },
	       {
	    	   xtype: 'customcombobox',
				name: 'paymentMode',
				itemId:'paymentMode',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
				store:Ext.create('Academia.store.feeandpayment.FeePaymentMode'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true 
	       }]	
	},
	{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[
		       {
		    	    xtype: 'customcombobox',
					name: 'voucherMode',
					itemId:'voucherMode',
					fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
					store:'feeandpayment.payment.VoucherMode',
					valueField: 'id',
					displayField: 'value',
					hidden:true,
					typeAhead:true,
					forceSelection:true
		       }
		       
		       ]
		
	},
	{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[
		{
			xtype : 'customcombobox',
			name : 'academicYear',
			itemId: 'academicYear',
			fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMIC_YEAR'),
			store : 'program.programDetails.programBatches.PrimaryAcademicStore',
			valueField : 'id',
			displayField : 'yearName',
			allowBlank : true,
			hidden:true,
			width: 256
		},{
			xtype : 'customcombobox',
			name : 'academyYearTenure',			
			itemId : 'academyYearTenure',			
			fieldLabel : getCommonTranslation('ACADEMY_YEAR_TENURE'),//Current Academic Year Tenure
			store : 'organization.academylocations.AcademicTenureStore',
			valueField : 'id',
			hidden:true,
			displayField : 'tenureName',
			editable:false
		}]},
		{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'fromdate',
				itemId:'fromdate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				endDateField: 'todate',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE')
			},{
				xtype: 'datefield',
				name: 'todate',
				itemId:'todate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				startDateField: 'fromdate',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('TILL_DATE')
			}]}
		]
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
