/**
 * @author harsh.Nagra
 */
Ext.define('Academia.view.feeandpayment.reports.PaymentPlanReportNameWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.paymentplanreportnamewindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '40%',
	width: '80%',
	frame: true,
	//title:getCommonTranslation('FEE_SUBHEADS'),
	items: [{
		xtype: 'grid',
		store : 'feeandpayment.reports.PaymentPlanReportNameStore',
		autoScroll: true,
		itemId : 'paymentplanreportnamewindowid',
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		 features: [{
		        ftype: 'summary',
		        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
		    }],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'feeandpayment.reports.PaymentPlanReportNameStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getFeeAndPaymentCommonTranslation('INSTALLMENT_NO'),
			dataIndex: 'sequence',
			align:'center',
			sortable: false,
			flex : .5	  
		},{
			header : getFeeAndPaymentCommonTranslation('INSTALMENT_TYPE'),
			dataIndex : 'amountType',
			sortable: false,
			flex : .5,
			renderer:function(value, meta){
				return getCommonTranslation(value);
				}
		},{ 
			header : getFeeAndPaymentCommonTranslation('AMOUNT'),
			dataIndex : 'amountTobePaid',
			sortable: false,
			flex : .5,	  
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return currencyRenderer(value,record.get("currencyId"));
				}                      
			} 
		},{ 
			header : getFeeAndPaymentCommonTranslation('PAYMENT_DATE'),
			dataIndex : 'paymentDate',
			sortable: false,
			flex : .5,
			renderer:function(value,meta){
				if(!isNullOrEmpty(value)) {
					return dateRender(value);
				}                         
			}
		},{ 
			header : getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
			dataIndex : 'schedulePaymentModes',
			sortable: false,
			flex : 1.5,	  
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					var obj = [];
					for(var j=0;j<record.data.schedulePaymentModes.length;j++){
						var mode=record.data.schedulePaymentModes[j];
						if(!isNullOrEmpty(mode.feePaymentMode)){
							obj.push(mode.feePaymentMode.value);
						}else{
							obj.push(mode.data.value);
						}
					}
					return obj;
				}	
			}
		},{
			header : getFeeAndPaymentCommonTranslation('STATUS'),
			dataIndex : 'status',
			align:'center',
			sortable: false,
			flex : .5,	
			renderer : function(value, metaData, record,
					row, col, store, gridView) {
				if (record.data.status == "Paid") {
					return 'Paid';
				} else if (record.data.status == "Not Paid"){
					return 'Unpaid';
				}else{
					return 'Pending';
				}
				
			}
		}] 	

	}]
});

