/**
 * @author Nitin gaikwad
 */
Ext.define('Academia.view.feeandpayment.reports.ProgramWiseFeeReportForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.programwisefeereportform',
	autoScroll : false,
	frame : false,
	cls : 'customSearchPanel',
	method : 'GET',
	standardSubmit : false,
	defaults : {
		labelAlign : 'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items : [ {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		width : '100%',
		defaults : {
			labelAlign : 'top',
			width: 256
		},
		items : [ {
			xtype : 'customcombobox',
			name : 'intakeyear',
			itemId: 'intakeyear',
			fieldLabel : getFeeAndPaymentCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStore'),
			valueField : 'id',
			displayField : 'value',
			allowBlank : true,
			width: 256
		},{
			xtype : 'customcombobox',
			name : 'programGroup',
			itemId:'programGroup',
			fieldLabel : getCommonTranslation('PROGRAM_GROUP'),
			store : Ext.create('Academia.store.program.ProgramGroupStore'),
			displayField : 'value',
			valueField : 'id',
			forceSelection : true
		}, {
			xtype : 'customcombobox',
			name : 'programId',
			itemId : 'programId',
			width: 256,
			fieldLabel :getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store : Ext.create('Academia.store.feeandpayment.reports.ProgramStudentByIntakeYearStore'),
			displayField : 'valueCode',
			valueField : 'id',
			typeAhead:true,
			forceSelection:true,
			queryParam:'programName',
			hideTrigger:false,
			triggerAction: 'all',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR')
		}]},
		{
		xtype : 'fieldset',
		title : getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout : 'vbox',
		frame : 'true',
		collapsible : true,
		collapsed : true,
		style : {
			marginTop : '33px!important'
		},
		width : '100%',
		listeners:{
			expand:function(cmp){
				Ext.defer(function(){
					cmp.up('studentfeereportfinalstructure').doLayout();
					cmp.up('studentfeereportfinalstructure').updateLayout();
				},100);
				
			}
		},
		items : [{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			width : '100%',
			defaults : {
				labelAlign : 'top',
				width: 256
			},
			items : [ 
			  {
				xtype : 'customcombobox',
				name : 'batchId',
				itemId : 'batchId',
				fieldLabel : getFeeAndPaymentCommonTranslation('BATCH'),
				disabled : true,
				store : Ext.create('Academia.store.enquiry.AcademicBatchStore'),
				valueField : 'id',
				displayField : 'value',
				typeAhead : true,
				forceSelection : true
			}, {
				xtype : 'customcombobox',
				name : 'seatTypeId',
				itemId : 'seatTypeId',
				disabled : true,
				store : Ext.create('Academia.store.feeandpayment.reports.ProgramBatchSeatIdByBatchStudentIdStore'),
				fieldLabel : getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
				valueField : 'id',
				displayField : 'value',
				typeAhead : true,
				forceSelection : true

			},
			{
				xtype: 'customcombobox',
				name: 'period',
				itemId : 'periodId',
				fieldLabel: getCommonTranslation('PERIOD'),
				store : Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
				displayField : 'value',
				valueField : 'id',
				hidden:true,
				//allowBlank: false,
				disabled : true
			}]},{
					xtype:'fieldcontainer',
					layout:'hbox',
					width: '100%',
					defaults: {
						width: 256,
						labelAlign: 'top'
					},
					items:[{
					xtype: 'datefield',
					name: 'fromdate',
					itemId:'fromdate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					endDateField: 'todate',
					editable:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE')
				},{
					xtype: 'datefield',
					name: 'todate',
					itemId:'todate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					startDateField: 'fromdate',
					editable:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('TILL_DATE')
				},{
		            xtype: 'checkboxfield',
		            width: 'auto',
		            style:{
		            	marginTop:'25px'
		            },
		            labelAlign: 'right',
		            itemId:'whetherApplicantId',
		            boxLabel: getCommonTranslation('ONLY_APPLICANT'),
		            name: 'whetherApplicant',
		            inputValue : true
		        }]
			}
	]
		}
		,
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			layout: 'hbox',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				//buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,  
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
}
);
