/**
 * @author Nitin Gaikwad
 */
Ext.define('Academia.view.feeandpayment.reports.ReceiptWithHeadReportGrid',
		{
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.receiptwithheadreportgrid',
	store : 'feeandpayment.reports.ReceiptWithHeadReport',
	title : getFeeAndPaymentCommonTranslation('RECEIPTS_WITH_HEAD_DETAILS'),
	cls:'centerAlignTitle',
	border : true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins : [ 'pagesize' ],
			store : 'feeandpayment.reports.ReceiptWithHeadReport',
			emptyMsg : getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	} ],
	initComponent : function() {
		var grid = this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnPrint',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
		formBind:true,
	}],
	columns : [
		{
			header : getCommonTranslation('RECEIPT_NUMBER'),//getFeeAndPaymentCommonTranslation('COLLECTED_BY_ID'),
			dataIndex : 'receiptNo',
			flex : 1,
			renderer:function(value){
				if(value){
					return  '<a href="#">'+value+'</a>';
				}
			},
			summaryRenderer: function(value, metaData, record, row, col, store, gridView){
				// return getFeeAndPaymentCommonTranslation('TOTAL');

				if(store.data.items[0].data.conversionType == "AL" || store.data.items[0].data.conversionType == "ORG") {
					// a = currencyRenderer('',store.data.items[0].data.acadLocBaseCurrencyId).split(" ");
					return getFeeAndPaymentCommonTranslation('Total (In ' + store.data.items[0].data.currencyName +')');
				}
				else {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				}

			}
		},
		{
			header : getCommonTranslation('RECEIPT_DATE'),
			dataIndex : 'receiptDate',
			flex : 1,
			renderer:function(date) {
				return dateRender(date);
			}
		},
		{

			header : getCommonTranslation('CURRENCY_EXCHANGE_RATE_DETAIL'),
			dataIndex : 'currencyExchangeRate',
			flex : 1.2

		},
		{
			header : getCommonTranslation('RECEIPT_AMOUNT'),
			dataIndex : 'receiptAmount',
			flex : 1.8,
			summaryType: 'sum',
			//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
									return  value;
								},*/
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("currencyId"));
				}
			},
			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
				return '';
			}
		},
		{
			header : getCommonTranslation('CONVERTED_RECEIPT_AMOUNT'),
			dataIndex : 'convertedReceiptAmount',
			flex : 1.2,
			summaryType : 'sum',
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("baseCurrencyId"));}
			},
			summaryRenderer: function (value, metaData, record, row, col, store, gridView) {return '';}

		},
		{
			header : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'academyLocationName',
			hidden:true,
			flex : 1
		},
		{
			header : getCommonTranslation('ID'),
			dataIndex : 'printId',
			flex : 1
		},
		{
			header : getCommonTranslation('NAME'),
			dataIndex : 'name',
			flex : 1
		},{
			header : getCommonTranslation('FIRST_NAME'),
			dataIndex : 'personFirstName',
			flex : 1,
			hidden: true
		},{
			header : getCommonTranslation('MIDDLE_NAME'),
			dataIndex : 'personMiddleName',
			flex : 1,
			hidden: true
		},{
			header : getCommonTranslation('LAST_NAME'),
			dataIndex : 'personLastName',
			flex : 1,
			hidden: true
		},{
			header : getCommonTranslation('FATHER_NAME'),
			dataIndex : 'fatherName',
			flex:1
		},{
			header : getCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			flex:1
		},{
			header : getCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			flex:1
		},{
			header : getCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatName',
			hidden:true,
			flex:1
		},
		{
			header : getCommonTranslation('VOUCHER_MODE'),
			dataIndex : 'voucherMode',
			flex : 1
		},
		{
			header : getCommonTranslation('REQUEST_CREATED_BY'),
			dataIndex : 'collectedByName',
			flex : 1
		},{
			header : getCommonTranslation('FEE_HEAD_GROUP'),
			dataIndex : 'groupingFeeHeadName',
			flex:1,
			hidden:true
		},{
			header : getCommonTranslation('FEE_HEADS'),
			dataIndex : 'feeHeadName',
			flex : 1
		},
		{
			header : getCommonTranslation('ADJUSTMENT_DATE'),
			dataIndex : 'adjustmentDate',
			flex : 1,
			hidden:true,
			renderer:function(date) {
				return dateRender(date);
			}
		},
		{
			header : getCommonTranslation('FEE_HEAD_AMOUNT'),
			dataIndex : 'feeHeadAmountRWHD',
			flex : 1.8,
			summaryType: 'sum',
			//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
									return  value;
								},*/
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("billCurrencyId"));
				}
			},
			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
				if(store.data.items[0].data.conversionType == 'EX'){
					return currencyRenderer(value, store.data.items[0].data.orgCurrency);
				}
				else {
					return '';
				}
			}
		},
		{
			header : getCommonTranslation('CONVERTED_FEE_HEAD_AMOUNT'),
			dataIndex : 'feeHeadAmountInALBaseCurrency',
			flex : 1.2,
			summaryType : 'sum',
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("baseCurrencyId"));
				}
			},
			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
				if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
					return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
				}
				else {
					return '';
				}
			}

		},
		{
			header : getCommonTranslation('NARRATION'), 
			dataIndex : 'narration',
			hidden:true,
			flex : 1
		}
		]

});
