/**
 *  @author Rajkumar.patidar
 */


Ext.define('Academia.view.feeandpayment.schedulepayment.SchedulePaymentListForPeriodType', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.schedulepaymentlistforperiodtype',
	store : 'feeandpayment.PaymentForPeriodType',
	border: true,
	selType:'checkboxmodel',
	selModel : {
		mode : 'MULTI',
		showHeaderCheckbox : true,
		allowDeselect : true,
		checkOnly : true,
		renderer : function(value, metaData, record, rowIndex,
				colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix
					+ 'grid-cell-special ' + baseCSSPrefix
					+ 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix
					+ 'grid-row-checker">&#160;</div>';
		}
	},
	//autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.PaymentForPeriodType',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		text:getFeeAndPaymentCommonTranslation('SAVE'),
		tooltip: getFeeAndPaymentCommonTranslation('ADD')
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('PERIOD'),
		dataIndex : 'programPeriodName',
		flex : 1	  
	},{
		header : getFeeAndPaymentCommonTranslation('BILLING_DATE'),
		dataIndex : 'billingDate',
		flex : 1,
		editor: {
			xtype: 'datefield',
			name: 'billingDate',
			itemId:'billingDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			editable:true
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{
		header : getFeeAndPaymentCommonTranslation('DUE_DAYS'),
		dataIndex : 'dueDays',
		flex : 1,
		editor : {
			xtype:'numberfield',
			name: 'dueDay',
			itemId:'dueDay',
			mouseWheelEnabled:false,
			allowDecimals:true,
			hideTrigger:true,
			minValue:0
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{ 
		header : getFeeAndPaymentCommonTranslation('DUE_DATE'),
		dataIndex : 'dueDate',
		flex : 1,
		editor: {
			xtype: 'datefield',
			name: 'dueDate',
			itemId:'dueDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			editable:true
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{ 
		header : getFeeAndPaymentCommonTranslation('AMOUNT'),
		dataIndex : 'amount',
		flex : 1,	  
		editor : {
			xtype:'numberfield',
			name: 'amount',
			itemId:'amount',
			mouseWheelEnabled:false,
			allowDecimals:true,
			hideTrigger:true,
			minValue:0
		},    
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		} 
	}],
	plugins: [{
  	  ptype : 'cellediting',
  	  clicksToEdit: 1
    }],
    listeners: {
        cellclick: function (sender, td, cellIndex, record, tr, rowIndex, e, eOpts) {
            clickedColIndex = cellIndex;
        },
        beforedeselect: function (rowmodel, record, index, eOpts) {
           return (clickedColIndex == 0);
        },
        headerclick:function(header, column, e, t,eOpts){
        	clickedColIndex = 0;
         }
}
});