/**
 * @author Amit Gupta
 */
Ext.define('Academia.view.filemanagement.AddFileInfoForm',{
	extend:'Academia.view.common.IdGeneratorForm',
	formCode: 'addFileInfoForm',
	alias : 'widget.addfileinfoform',
	frame:true,
	title: getFileManagementTranslation('FILE_INFORMATION'),
	method: 'POST',
	defaults: {
		labelAlign: 'top',
	},
	plugins : "formlabelrequired",
	cls: 'x-form-fixed-footer-parent',
	items : [{
		xtype: 'hidden',
		name: 'id',
		itemId:'id'
			
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'nestedJsonCombo',
			name: 'fileType',
			itemId:'fileType',
			store:'filemanagement.FileTypeStore',
			allowBlank:false,
			fieldLabel: getFileManagementTranslation('FILE_TYPE'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			editable: false,
            disableKeyFilter: false,
			forceSelection:true  
		},{
			xtype : 'textfield',
			name : 'fileNumber',
			itemId:'fileNumber',
			maxLength: 20, 
			fieldLabel : getFileManagementTranslation('FILE_NUMBER'),
			emptyText: getCommonTranslation('ID_AUTOGENERATE'),
			allowBlank:false
		},{
			xtype : 'textfield',
			name : 'fileSubject',
			itemId:'fileSubject',
			fieldLabel : getFileManagementTranslation('FILE_TITLE'),
			allowBlank:false
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'multiselectcombofield',
			name: 'fileAcademyLocations',
			itemId:'fileAcademyLocations',
			fieldLabel: getFileManagementTranslation('MEMBER_ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			cls:'multiBrandCampusCls',
			allowBlank : false,
			valueField : 'id',
			width: 536,
			displayField : 'value' 
		},{
			xtype: 'nestedJsonCombo',
			name:'fileOwner',
			itemId:'fileOwner',
			fieldLabel : getFileManagementTranslation('FILE_OWNER'),
			store: 'criteriabuilder.userquicksearch.QuickSearchName',
			msgTarget: 'qtip',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            hideTrigger:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		}]
	},{

		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'datefield',
			name: 'creationDate',
			itemId:'creationDate',
			//--submitFormat:CONSTANTS.DATE_FORMAT,
			vtype: 'daterange',
			endDateField: 'dueDate',
//			value:new Date(),
			editable:false,
			allowBlank:true,
			fieldLabel:getFileManagementTranslation('CREATION_DATE'),
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}
		},{
			xtype: 'datefield',
			name: 'dueDate',
			itemId:'dueDate',
			//--submitFormat:CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
//			vtype: 'daterange',
//			startDateField: 'creationDate',
			editable:false,
			fieldLabel:getFileManagementTranslation('DUE_DATE')
		},{
			
			xtype: 'nestedJsonCombo',
			name: 'priority',
			itemId:'priority',
			store:'filemanagement.FilePriorityStore',
			allowBlank:true,
			fieldLabel: getFileManagementTranslation('PRIORITY'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			editable: false,
            disableKeyFilter: false,
			forceSelection:true 
		}]    
	},{
		xtype: 'textarea',
		name:'otherDetail',
		itemId:'otherDetail',
		width: 536,
		maxLength : 250,
		fieldLabel: getFileManagementTranslation('OTHER_DETAILS')
	},{
		xtype: 'textarea',
		name:'remarks',
		itemId:'remarks',
		width: 536,
		maxLength : 250,
		fieldLabel: getFileManagementTranslation('ADD_REMARK')
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		cls: 'form-fixed-footer',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE') ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
    		text: getCommonTranslation('RESET'),
    		//itemId: 'programFormCancelButtonId',
    		itemId: 'resetBtn',
    		ui: 'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
