/**
 * @author Amit Gupta
 */
Ext.define('Academia.view.filemanagement.FileAssignToForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.fileassigntoform',
	title:getFileManagementTranslation('ASSIGN_TO'),
	frame: true,
	autoScroll:false,
	modal:true,
	method: 'POST',
	cls: 'x-form-fixed-footer-parent',
	items: [{
		itemId:'winFileassigntoform',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			//width:440,
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			itemId:'fileAssignContainerId',
			items:[{
				xtype : 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items : [{
					xtype: 'customcombobox',
	                name: 'userType',
	                itemId: 'userType',
	                fieldLabel: getFileManagementTranslation('USER_TYPE'),
	                editable: false,
		            disableKeyFilter: false,
	                valueField: 'id',
	                displayField: 'userGroupName',
	                allowBlank:false,
	                store: 'attendance.UserGroup'
	              
				},{
					xtype: 'customcombobox',
					name:'assignedUser',
					itemId:'assignedUser',
					fieldLabel : getFileManagementTranslation('USER'),
//					store: 'hostel.roomallocation.UserSmartSearchByUserType',
					msgTarget: 'qtip',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'codeOrName',
					minChars:3,
					allowBlank: false,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					listeners:{
						render : function(combo){
							var store=Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType');
							combo.bindStore(store)
						}
					},
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				},{
					xtype: 'button',
					itemId: 'addFilterBtn',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'30px'
					}
				  }]
				}]
		},{
			
			xtype:'fieldcontainer',
			itemId:'filAssignToId',
			items:[{
				xtype : 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items : [{
					xtype: 'datefield',
					name: 'assignmentDate',
					itemId:'assignmentDate',
					//--submitFormat:CONSTANTS.DATE_FORMAT,
					vtype: 'daterange',
					endDateField: 'dueDate',
					editable:false,
//					value:new Date(),
					allowBlank:false,
					fieldLabel:getFileManagementTranslation('DATE_OF_ASSIGNMENT'),
					listeners: {
						render: function(obj) {
							obj = dateFormatRender(obj);						
							obj.setValue(new Date());
						}
					}
				},{
					xtype: 'datefield',
					name: 'dueDate',
					itemId:'dueDate',
					//--submitFormat:CONSTANTS.DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype: 'daterange',
					startDateField: 'assignmentDate',
					editable:false,
					fieldLabel:getFileManagementTranslation('DUE_DATE')
				}]
			}]

		},{
			xtype: 'textarea',
			name:'remarks',
			itemId:'remarks',
			width: 536,
			maxLength : 250,
			fieldLabel: getFileManagementTranslation('REMARKS')
		},{
			xtype:'fieldcontainer',
			layout : {
				type : 'hbox'
			},
			width:'auto',
			cls: 'form-fixed-footer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
	    		text: getCommonTranslation('RESET'),
	    		//itemId: 'programFormCancelButtonId',
	    		itemId: 'resetBtn',
	    		ui: 'CustomBtnCancel',
	    		scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});
