/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.filemanagement.ManageFilesFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.managefilesfilter',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'fileType',
			itemId: 'fileTypeId',
			fieldLabel:getServiceRequestTranslation('FILE_TYPE'),
			store:'filemanagement.FileTypeStore',
			valueField: 'id',
			displayField: 'value',
			queryParam:'fileType',
			minChars:3,
			editable: false,
            disableKeyFilter: false,
			//width: 536,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
//			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
//			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name:'fileNo',
			itemId:'fileNoId',
			store:'filemanagement.FileNumberStore',
			fieldLabel:getServiceRequestTranslation('FILE_NO'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'fileNo',
			minChars:3,
//			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype:'customcombobox',
			name:'fileOwner',
			itemId:'fileOwnerId',
			fieldLabel : getFileManagementTranslation('FILE_OWNER'),
			store: 'criteriabuilder.userquicksearch.QuickSearchName',
			msgTarget: 'qtip',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            hideTrigger:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		}]
	},{
		xtype:'fieldset',
		itemId:'fileMoreFilterId',
		title:getServiceRequestTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		width:'100%',
		defaults: {
			labelAlign: 'top',
			//width: 256
		},
		style: {
			marginTop: '40px!important',
			//marginLeft:'-10px !important'
		},
		items:[{
			xtype:'fieldcontainer',
			layout: 'hbox',
			style: {
				//marginTop: '40px!important',
				marginLeft:'-0px !important'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype:'customcombobox',
				name:'fileStatus',
				itemId:'fileStatusId',
				store:'filemanagement.FileStatusStore',
				fieldLabel:getServiceRequestTranslation('FILE_STATUS'),
				valueField: 'id',
				editable: false,
	            disableKeyFilter: false,
				displayField: 'value',
				forceSelection:true
			}, {
				xtype:'customcombobox',
				name:'priority',
				itemId:'priorityId',
				store:'filemanagement.FilePriorityStore',
				allowBlank:true,
				editable: false,
	            disableKeyFilter: false,
				fieldLabel: getFileManagementTranslation('PRIORITY'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				disabled:false,
				forceSelection:true 
			},{
				xtype:'customcombobox',
				name:'acknowledgment',
				itemId:'acknowledgment',
				store:'filemanagement.FileAcknowledeStore',
				fieldLabel: getFileManagementTranslation('ACKNOWLEDGMENT_STATUS'),
				minChars:3,
				editable: false,
	            disableKeyFilter: false,
				valueField: 'id',
				displayField: 'value',
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
//				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
//				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			}]
		},{

			/*xtype:'label',
			text:'<u>'+ getCommonTranslation('ENQUIRY_INFORMATION')+'</u>',
//			labelStyle: 'font-weight:bold',
			style: 'font-weight:bold;',*/
			xtype:'displayfield',
			value:'<b class="menu-title">'+getServiceRequestTranslation('CREATION_DATE')+'</b>',
			style: {
				textDecoration: "underline"
			}
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			style:{
//				marginTop:'40px!important'
			},
			items:[{
				xtype: 'datefield',
				name:'creation_fromDate',
				itemId:'creation_fromDateID',
				fieldLabel:getServiceRequestTranslation('FROM_DATE'),
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				endDateField: 'creation_toDateId',
				editable:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'datefield',
				name:'creation_toDate',
				itemId:'creation_toDateId',
				fieldLabel:getServiceRequestTranslation('TO_DATE'),
				vtype: 'daterange',
				startDateField: 'creation_fromDateID',
				editable:false,
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{

				xtype: 'checkboxfield',
				width: 'auto',
				width: 256,
				style:{
					marginTop:'25px'
				},
				//labelAlign: 'right',
				itemId:'accessAllFilesItemId',
				boxLabel: getFeeAndPaymentCommonTranslation('ACCESS_ALL_FILES'),
				name: 'accessAllFiles',
				inputValue : true
			
			}]	
		},{

			/*xtype:'label',
			text:'<u>'+ getCommonTranslation('ENQUIRY_INFORMATION')+'</u>',
//			labelStyle: 'font-weight:bold',
			style: 'font-weight:bold;',*/
			xtype:'displayfield',
			value:'<b class="menu-title">'+getCommonTranslation('DUE_DATE')+'</b>',
			style: {
				textDecoration: "underline"
			}
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			style:{
//				marginTop:'40px!important'
			},
			items:[{
				xtype: 'datefield',
				name:'due_fromDate',
				itemId:'due_fromDateId',
				fieldLabel:getServiceRequestTranslation('FROM_DATE'),
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				endDateField: 'due_toDateId',
				editable:false,
			},{
				xtype: 'datefield',
				name:'due_toDate',
				itemId:'due_toDateId',
				fieldLabel:getServiceRequestTranslation('TO_DATE'),
				vtype: 'daterange',
				startDateField: 'due_fromDateId',
				editable:false,
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		}]
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			//formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
