/*
 * Kamlesh
 */
Ext.define('Academia.view.gradeMaster.group.GroupMasterAddForm', {
	extend: 'Ext.window.Window',
    alias: 'widget.groupmasteraddform',
    title: getExaminationTranslation('ADD_GROUP'),
    modal: true,
    width: '23%',
   items: [{
	   xtype:'form',
    autoScroll: true,
    method: 'POST',
    layout: {
        type: 'vbox'
    },
    standardSubmit: false,
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    plugins:"formlabelrequired",
    items: [{
	        xtype: 'hidden',
	        name: 'id'
	    },{
            xtype: 'textfield',
            name: 'groupName',
            fieldLabel: getExaminationTranslation('GROUP_NAME'),
            maxLength:35,
            allowBlank: false
        },{
            xtype: 'numberfield',
            name: 'minPercent',
            fieldLabel: getExaminationTranslation('MIN_PERMISSIBLE_PERCENTAGE'),
            minValue : 0,
        	mouseWheelEnabled :false,
        	hideTrigger :true,
        	allowExponential:false,
        	allowDecimals:false,
            allowBlank: false
    	},{
            xtype: 'numberfield',
            name: 'maxPercent',
            fieldLabel: getExaminationTranslation('MAX_PERMISSIBLE_PERCENTAGE'),
            minValue : 0,
        	mouseWheelEnabled :false,
        	hideTrigger :true,
        	allowExponential:false,
        	allowDecimals:false,
            allowBlank: false
        },{
    		xtype: 'fieldcontainer',
            width:'95%',
            cls:'windowBtnPos',
        items: [{
            xtype: 'button',
            text: getExaminationTranslation('SAVE'),
            itemId: 'groupMasterAddButtonId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getExaminationTranslation('CANCEL'),
            itemId: 'groupMasterCancelButtonId',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
   }]


});