/**
 * @author Amit G
 * 
 */
Ext.define('Academia.view.hostel.accommodationProvider.AccommodationProviderForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	mixins: {
		extend: 'Academia.view.common.IdGeneratorForm'
	},
	alias : 'widget.accommodationproviderform',
	frame:true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	title: getHostelTranslation('ACCOMMODATION_PROVIDER_DETAILS'),
	method: 'POST',
	defaults: {
		labelAlign: 'top',
	},
	plugins : "formlabelrequired",
	cls:'x-form-fixed-footer-parent',

	items : [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 240,
			labelAlign : 'top'
		},
		items : [{
			xtype:'textfield',
			fieldLabel:getHostelTranslation('PROVIDER_CODE'),
			itemId:'providerCode',
			maxLength : 50,
			name:'providerCode'
		},{
			xtype : 'textfield',
			name : 'accommodProviderName',
			itemId:'accommodProviderNameId',
			regex: /[a-zA-Z0-9]+/,
			maxLength : 150,
			fieldLabel : getHostelTranslation('ACCOMMODATION_PROVIDER_NAME'),
			allowBlank:false
		},{
            xtype: 'customcombobox',
            name: 'accreditationStatus',
            itemId: 'accreditationStatusId',
            fieldLabel: getHostelTranslation('ACCREDITATION_STATUS'),
            store: Ext.create('Academia.store.hostel.accommodationProvider.AccreditationStatusStore'),
            valueField: 'id',
            allowBlank: false,
            displayField: 'value',
            forceSelection: true,
            editable: false, 
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 240,
			labelAlign : 'top'
		},
		items : [{
			xtype:'textfield',
			fieldLabel:getHostelTranslation('CONTACT_PERSON_NAME'),
			itemId:'contactPersonName',
			name:'contactPerson',
			regex: /[a-zA-Z0-9]+/,
			maxLength : 150,
			forceSelection:true,
			allowBlank:false
		},{
			xtype : 'textfield',
			name : 'contactEmail',
			vtype: 'email',
			itemId:'contactEmailId',
			maxLength: '100',
			fieldLabel : getHostelTranslation('CONTACT_EMAIL'),
			allowBlank:false
		},{
            xtype: 'customcombobox',
            name: 'status',
            itemId: 'statusId',
            fieldLabel: getHostelTranslation('STATUS'),
            store: Ext.create('Academia.store.hostel.accommodationProvider.ActiveStatusStore'),
            valueField: 'id',
            allowBlank: false,
            displayField: 'value',
            forceSelection: true,
            editable: false, 
		}]
	
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'vbox'
		},
		defaults : {
			labelAlign : 'top'
		},
		items : [{
            xtype      : 'radiogroup',
            fieldLabel : getCommonTranslation('INTELLIMALI_PROVIDER'),
            itemId: 'intellimaliRegisteredItemId',
            name: 'isIntellimaliRegistered',
            defaults: {
                flex: 1
            },
            layout: 'hbox',
            items:[{ 
                boxLabel: getCommonTranslation('YES'), 
                name: 'isIntellimaliRegistered', 
                itemId:'isIntellimaliRegisteredYes',
                margin: '0 50 0 0',
                inputValue: true
            },{ 
                boxLabel: getCommonTranslation('NO'), 
                name: 'isIntellimaliRegistered', 
                itemId:'isIntellimaliRegisteredNo',
                inputValue: false,
                checked:true
            }]
        },{
				
			html: '<i>'+getAdmissionTranslation('ENTER_ANY_ONE_CONTACT_Details')+'</i>'+'<span class="required" style="color:red"> *</span>',
			margin: 0,
			width:800
		},{
			xtype: 'fieldcontainer',
			fieldLabel: getHostelTranslation('TEL'),		
			name: 'phoneNoFldItem',
			itemId : 'phoneNoFldItemId',
			name: 'phoneNoFldItem',
			layout : {
				type : 'hbox'
			},
			defaults: {
                enforceMaxLength: true,
                labelAlign: "top",
                width: 240
            },
			items : [ {
				xtype : 'customcombobox',
				hiddenName : 'phoneNumber1',
				valueField : 'isdCode',
				displayField : 'isdCode',
				store:Ext.create('Academia.store.common.CountryStore'),
				triggerAction : 'all',
				name : 'phoneCountryCode',
				itemId : 'phoneCountryCode',
				forceSelection:true,
				width:100,
				minChars: 1
			}, {
				xtype : 'numberfield',
				name : 'phoneAreaCode',
				width: 108,
				maxLength: 5,
				enforceMaxLength : true,
				// To Remove spinner buttons, and arrow key and mouse wheel listeners
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential:false,
				itemId : 'phoneAreaCode',
			}, {
				xtype : 'numberfield',
				itemId : 'phoneNoField',
				name : 'phoneNo',
				maxLength: 10,
				enforceMaxLength : true,
				// To Remove spinner buttons, and arrow key and mouse wheel listeners
				hideTrigger: true,
				width: 240,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential:false
			} ]
		}, {
			xtype: 'fieldcontainer',
			itemId : 'mobileNoFldItemId',
			name: 'mobileNoFldItem',
			fieldLabel: getHostelTranslation('CELL_PHONE'),
			layout : {
				type : 'hbox'
			},
			defaults: {
                   enforceMaxLength: true,
                   labelAlign: "top",
                   width: 240
               },
			items : [ {
				xtype : 'customcombobox',
				name : 'mobileCountryCode',
				itemId : 'cellCountryCode',
				valueField : 'isdCode',
				displayField : 'isdCode',
				store:Ext.create('Academia.store.common.CountryStore'),
				triggerAction : 'all',
				forceSelection:true,
				width:  100,
				minChars: 1
			}, {
				xtype : 'numberfield',
				name : 'mobileNumber',
				itemId : 'mobileNumber',
				minLength: 0,
				maxLength: 15,
				enforceMaxLength : true,
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential:false,
				width : 240,
			//	allowBlank :false,
			   //allowBlank :false,
			}]
		}]
	},{

		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 240,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'textarea',
			name:'address',
			itemId:'address',
			allowBlank:false,
			regex: /[a-zA-Z0-9]+/,
			width: 536,
			maxLength : 250,
			fieldLabel: getHostelTranslation('ADDRESS')
		}]    
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 240,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'numberfield',
			fieldLabel: getHostelTranslation('ROOMS_AVAILABLE'),
			name: 'roomsAvailable',
			itemId : 'roomsAvailable',
			allowBlank:false,
			allowExponential :false,
            allowDecimals: false,
			maxLength: 7,
			minValue : 0
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		cls:'form-fixed-footer',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE') ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}/*,{
			xtype: 'button',
    		text: getCommonTranslation('RESET'),
    		itemId: 'resetBtn',
    		ui: 'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE
		}*/]
	}]
});