/**
 *  @author Amit G
 */
Ext.define('Academia.view.hostel.accommodationProvider.AccommodationProviderGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.accommodationprovidergrid',
	store : 'hostel.accommodationProvider.AccommodationProviderGridStore',
	title: getHostelTranslation('LIST_OF_ACCOMMODATION_PROVIDER'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'accommodationproviderstructure':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.accommodationProvider.AccommodationProviderGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		//var grid=this;    
		//grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getHostelTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getHostelTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getExaminationTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getHostelTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getHostelTranslation('PROVIDER_CODE'),
		dataIndex : 'providerCode',
		flex:1
	},{
		header : getHostelTranslation('ACCOMMODATION_PROVIDER_NAME'),
		dataIndex : 'accommodProviderName',
		flex:1.5
	},{
		header : getHostelTranslation('ACCREDITATION_STATUS'),
		dataIndex : 'accreditationStatus',
		flex:2,
		renderer : function(value){
			if(value=='ACCREDITED'){
				return getHostelTranslation('ACCREDITED');
			}else{
				return getHostelTranslation('UNACCREDITED');
			}  	
		}
	},
	{
		header : getHostelTranslation('INTELLIMALI_PROVIDER'),
		dataIndex : 'isIntellimaliRegistered',
		renderer : function(value, metadata, record) {
			var val = value;
			if(record.data.isIntellimaliRegistered === true)
			{
				val = "Yes";
			}else{
				val = "No";
			}
			return val;
		},
		flex : 1
	},{
		header : getHostelTranslation('CONTACT_PERSON_NAME'),
		dataIndex : 'contactPerson',
		flex : 1
	},{
		header : getHostelTranslation('TEL'),
		dataIndex : 'phoneNo',
		flex : 1,
		renderer : function(value, metadata, record) {
			var val = value;
			if(!isNullOrEmpty(record.data.phoneCountryCode) && !isNullOrEmpty(record.data.phoneAreaCode)) {
				val = record.data.phoneCountryCode+ "-"+record.data.phoneAreaCode + value;
			}
			return val;
		}
	},{
		header : getHostelTranslation('CELL_PHONE'),
		dataIndex : 'mobileNo',
		flex : 1,
		renderer : function(value, metadata, record) {
			var val = value;
			if(!isNullOrEmpty(value)) {
				val = record.data.mobileCountryCode+ "-" + value;
			}
			return val;
		}
	},{
		header : getHostelTranslation('CONTACT_EMAIL'),
		dataIndex : 'contactEmail',
		flex : 1
	},{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer : function(value){
			if(value=='ACTIVE'){
				return getHostelTranslation('ACTIVE');
			}else{
				return getHostelTranslation('INACTIVE');
			}  	
		}
	},{
		header : getHostelTranslation('ADDRESS'),
		dataIndex : 'address',
		flex : 2
	},{
		header : getHostelTranslation('ROOMS_AVAILABLE'),
		dataIndex : 'roomsAvailable',
		flex : 1
	}
	],
	 disableButtonsByPivileges: function(privilegeList) {
	    	/*TODO: remove the console after understanding, This prints only those permissions
	     	 * which the user has.
	     	 * accordingly the buttons will be hidden/shown 
	    	 */
	    	buttonsToolBar = this.query('toolbar[dock=top]')[0];//this.query('#sunsuccessButtonsToolbar')[0];
	    	try{
	    		var gridItemId = this.itemId;//buttonsToolBar.up('grid').itemId;
	    	}
	    	catch(e){
	    		var gridItemId = '';
	    	}
	    	/**
	    	 * querying the buttons and unhiding them if any.
	    	 */
	    	var buttons = buttonsToolBar.query('button');
	    	Ext.each(buttons, function(button) {
	    		button.setVisible(false);
	    	});
	    	
	    	Ext.each(privilegeList, function(privilege) {
	    		if(privilege === 'DELETE') {
	    			var button = buttonsToolBar.query('#btnDelete')[0];
	    			if(button != undefined) {
	    				button.setVisible(true);
	    			}
	        	} else if (privilege === 'UPDATE') {
	        		var button = buttonsToolBar.query('#btnEdit')[0];
	        		if(button != undefined) {
	    				button.setVisible(true);
	    			}
	        	} else if (privilege === 'CREATE'){
	        		var button = buttonsToolBar.query('#btnAdd')[0];
	        		if(button != undefined) {
	    				button.setVisible(true);
	    			}
	        	} else if (privilege === 'VIEW_DETAILS') {
	        		var button = buttonsToolBar.query('#btnView')[0];
	        		if(button != undefined) {
	    				button.setVisible(true);
	    			}
	        	}  
	        	
	        	
	    	});
	    }
});