/*
 *  @author Pankaj Sisodiya
 * 
 */
Ext.define('Academia.view.hostel.hostelApplicationSetup.HostelApplicationSetupMapProgramGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.hostelApplicationSetupMapProgramGrid',
	store: 'hostel.HostelApplicationSetup.HostelApplicationSetupMapProgramGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	autoScroll: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.HostelApplicationSetup.HostelApplicationSetupMapProgramGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		disabled:true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		disabled:true
	}],
	columns: [{
		header:  getProgramandcourseTranslation("ACADEMY_LOCATION"),
		dataIndex: 'academyName',
		flex:1,
		sortable:false
	},{
		header:  getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		dataIndex: 'programAndCode',
		flex:1,
		sortable:false,
		renderer:function(value,metadata,record){
			if(!isNullOrEmpty(record)){
				return record.data.programCode+'/'+record.data.programName;
			}else{
				return  '';
			}
		}
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:1,
		sortable:false
	},{
		header:  getCommonTranslation('SEAT_TYPE'),
		dataIndex: 'seatTypeName',
		flex:1,
		sortable:false
	}]
});