/**
 * @author Pankaj Sisodiya
 */
Ext.define('Academia.view.hostel.hostelApplicationSetup.HostelSetupAddMappingSeatTypeGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.hostelSetupAddMappingSeatTypeGrid',
	title : getCommonTranslation('SEAT_TYPE'),
	store: 'hostel.HostelApplicationSetup.HostelSetupSeatTypeStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	border: true,
	 dockedItems: [{
	        xtype: 'toolbar',
	        dock: 'bottom',
	        items: [{
	            xtype: 'custompagingtoolbar',
	            plugins: ['pagesize'],
	            store: 'hostel.HostelApplicationSetup.HostelSetupSeatTypeStore',
	            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	            displayInfo: true
	        }]
	    }],
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitFeeMapping',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'batchSeatType',
		itemId:'batchSeatType',
		store: 'committee.committee.CommitteeBatchSeatTypeStore',
		valueField: 'programBatchSeatTypeId',
		displayField: 'seatName',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'qry',
		queryMode: 'remote',
		width: 256,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		dataIndex : 'codeValue',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatName',
		flex : 1	 
	}]
});