/**
 *  @author Pankaj Sisodiya
 */
Ext.define('Academia.view.hostel.hostelapplication.CancelApplicationWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.cancelApplicationWin',
	title:getHostelTranslation('CANCEL_APPLICATION'),
	frame: true,
	autoScroll:false,
	modal:true, 
	height: 300,
	width: '20%',
	items: [{
        xtype: 'form',
        plugins : "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            layout: 'vbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{

				xtype: 'customcombobox',
				fieldLabel: getHostelTranslation('CANCELLED_BY'),
				name:'cancelledBy',
				itemId:'cancelledBy',
				store: 'criteriabuilder.userquicksearch.QuickSearchName',
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				allowBlank: false,
				typeAhead:false,
	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            enableKeyEvents  : 'true',
	            hideTrigger:false,
	            //cls:'gridInputCustomStyle',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            triggerAction: '',
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{value}' +
		                    '</div>';
		                }
		            }
            	
            }, {
            	xtype : 'textareafield',
            	name : 'cancelReason',
            	itemId : 'cancelReason',
            	fieldLabel: getHostelTranslation('CANCELLATION_REASON'),
            	allowBlank:false,
            	maxLength : 1000
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            style: {
                marginTop: '17px',
                marginLeft: '-2px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'cancelSubmitBtn',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                buttonAlign: 'right',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]     
});