/**
 *  @author Deepak Sharma
 */
Ext.define('Academia.view.hostel.hostelapplication.HostelApplicationList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.hostelapplicationlist',
	store : 'hostel.hostelapplication.HostelApplicationStore',
	title: getHostelTranslation('HOSTEL_APPLICATIONS'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	//renderTo: Ext.getBody(),
    /*selModel: {
        selType: 'checkboxmodel'
    },*/
	selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'hostelapplicationsstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.hostelapplication.HostelApplicationStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnApplyRule',
		text: getCommonTranslation('APPLY_RULE')
	},{
		xtype: 'button',
		itemId: 'btnAllotRoom',
		text: getHostelTranslation('ALLOT_ROOM')
	},{
		xtype: 'button',
		itemId: 'btnRejectApplication',
		text: getCommonTranslation('REJECT_APPLICATION')
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text: getCommonTranslation('SEND_OFFER_LETTER'),
			itemId: 'sendOfferLetter',
		},{
			text:getCommonTranslation('REVOKE_OFFER_LETTER'),
			itemId:'revokeOfferLetter'
		},{
			text:getCommonTranslation('PRINT_OFFER_LETTER'),
			itemId:'printOfferLetter',
		},{
			text:getCommonTranslation('ASSIGN_CATEGORY'),
			itemId:'assignOfferLetter'
		},{
			text:getCommonTranslation('ASSIGN_OFFER_EXPIRY_DATE'),
			itemId:'assignOfferExpiryDate'
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header : getHostelTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex:1
	},{
		header : getHostelTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('INTAKE_YEAR'),
		dataIndex : 'intakeYear',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('ACADEMIC_YEAR'),
		dataIndex : 'academicYear',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('PROGRAM_GROUP'),
		dataIndex : 'programGroup',
		flex:1,
		hidden:true
	},{
		header : getHostelTranslation('PROGRAM'),
		dataIndex : 'program',
		flex:1
	},
	{
		header : getHostelTranslation('BATCH'),
		dataIndex : 'batch',
		flex:1
	},
	{
		header : getHostelTranslation('PERIOD'),
		dataIndex : 'period',
		flex:1
	},
	{
		header : getHostelTranslation('SEAT_TYPE'),
		dataIndex : 'seatType',
		flex:1
	},
	{
		header : getPersonModuleTranslation('SECTION'),
		dataIndex : 'section',
		flex:1
	},
	{

		header : getCommonTranslation('HOSTEL_STATUS'),
		dataIndex : 'hostelStatus',
		flex:1,
		renderer : function(value) {
			var val = '';
			if(value == 'AVAILABLE') {
				val = '<span style="color:Green;">' +'Available'+ '</span>';
			}else if(value == 'NOT_AVAILABLE') {
				val = '<span style="color:red;">' +'Not Available'+ '</span>';
			}else if(value == 'REJECTED') {
				val = '<span style="color:red;">' +'Rejected'+ '</span>';
			}else if(value == 'PENDING') {
				val = '<span style="color:red;">' +'Pending'+ '</span>';
			}
			return val;
		}
		
	},
	{
		header : getFeeAndPaymentCommonTranslation('SETTLEMENT_STATUS'),
		dataIndex : 'billStatus',
		flex:1,
		renderer : function(value) {
			var val = '';
			if(value == 'SETTLED') {
				val = 'Settled';
			}else if(value == 'REVERSED') {
				val = 'Reversed';
			}else if(value == 'PARTLY_SETTLED') {
				val = 'Pending';
			}else if(value == 'FULLY_PENDING') {
				val = 'Pending';
			}else if(value == 'CANCELLED') {
				val = 'Cancelled';
			}else if(value == 'PENDING') {
				val = 'Pending';
			}
			return '<a href=#>'+val+'</a>';
		}
	},
	{
		header : getCommonTranslation('SERVICE_OPT_IN_DATE'),
		dataIndex : 'serviceOptInDate',
		flex:1
	},{
		header : getCommonTranslation('WAITING_LIST_TYPE'),
		dataIndex : 'waitingListType',
		flex:1,
		hidden:true
	}]
});