/**
 *  @author Deepak Sharma
 */
Ext.define('Academia.view.hostel.hostelapplication.HostelApplicationSearch', {
	extend:'Academia.view.common.IdGeneratorForm',
	//extend: 'Ext.form.Panel',
	alias: 'widget.hostelapplicationsearch',
	autoScroll: false,
	frame: false,
	cls:'customSearchInnerPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
	style: {
		margin: '0 16px 0 0 !important;'
	},
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
         	xtype: 'customcombobox',
            name: 'applicantType',
            itemId:'applicantType',
            fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_TYPE'),
            store: 'hostel.hostelapplication.HostelApplicationTypeStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
	        editable: false
		},{
			xtype: 'customcombobox',
			name: 'locationId',
			itemId: 'locationItemId',
			fieldLabel: getCommonTranslation('LOCATION'),
			store: 'hostel.managehostel.hostel.LocationCodeName',
			displayField: 'value',
			valueField: 'id',
			editable: false,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'academyLocationId',
			itemId: 'academyLocationItemId',
			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
			store: 'hostel.hostelapplication.HostelApplicationALStore',
			displayField: 'value',
			valueField: 'id',
			editable: false,
			forceSelection:true,
			//queryParam: 'qry',
			width: 536
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'customcombobox',
			name:'hstlApplicationsApplicantName',
			itemId:'hstlApplicationsApplicantName',
			store:Ext.create('Academia.store.admission.applications.applicantProfileBase.ApplicantSmartSearchStore'),
			fieldLabel:getAdmissionTranslation('APPLICANT_ID_NAME'),
			width: 256,
			valueField: 'code',
			displayField: 'printName',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code}/{printName}'  +
	                    '</div>';
	                }
	            }
		},{
			xtype: 'customcombobox',
			name:'hstlApplicationsHostelCode',
			itemId:'hstlApplicationsHostelCode',
			store:'hostel.managehostel.hostel.HostelCodeName',
			fieldLabel:getHostelTranslation('HOSTEL_CODE_NAME'),
			width: 256,
			valueField: 'id',
			displayField: 'value',
			queryParam:'hostelnameorcode',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code}/{printName}'  +
	                    '</div>';
	                }
	            }
		},
		{
			xtype: 'customcombobox',
			name: 'hstlYear',
			itemId:'hstlYear',
			fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
			store: 'hostel.hostelapplication.HostelApplicantYearStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection:true
		},
		{
			xtype: 'customcombobox',
			name: 'hstlWaitingList',
			itemId:'hstlWaitingList',
			fieldLabel: getCommonTranslation('HOSTEL_CONFIGURATION_ID_NAME'),
			store:Ext.create('Academia.store.hostel.hostelapplication.WaitingListForApplicantStore'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection:true,
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'customcombobox',
			name: 'hstlDepositCategory',
			itemId:'hstlDepositCategory',
			fieldLabel: getFeeAndPaymentCommonTranslation('DEPOSIT_CATEGORY'),
			store: 'hostel.hostelapplication.HostelApplicantDepositCategoryListStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'hstlApplicationstatus',
			itemId:'hstlApplicationstatus',
			fieldLabel: getCommonTranslation('APPLICATION_STATUS'),
			store: 'hostel.hostelapplication.HostelApplicationStatusComboStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'hstlSettlementStatus',
			itemId:'hstlSettlementStatus',
			fieldLabel: getFeeAndPaymentCommonTranslation('SETTLEMENT_STATUS'),
			store: 'hostel.hostelapplication.HostelSattlementStatusStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection:true
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchButtonId',
			//buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButtonId',
			//buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}]
});
