/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.hostelattendance.HostelMarkAttendanceGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.hostelmarkattendancegrid',
	store :'hostel.hostelattendance.HostelMarkAttendanceGridStr',
	title: getHostelTranslation('LIST_OF_STUDENTS'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	
	initComponent: function() {
		var grid=this;    
		//grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SAVE'),
		itemId: 'submitBtn',
		formBind:true,
		disabled : true,
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype : 'radiogroup',
		itemId:'markAttendanceId',
		width: 765,
		cls: 'capture-hostel-attendance-radio',
		defaults: {
			flex: 1
		},
		items : [
			{
				boxLabel : getHostelTranslation('MARK_ALL_PRESENT'),
				name : 'markAttendance',
				inputValue : 'PRESENT',
				style:{
					marginLeft:'15px'
				},
			},{
				boxLabel : getHostelTranslation('MARK_ALL_ABSENT'),
				name : 'markAttendance',
				inputValue : 'ABSENT',
			},{
				boxLabel : getHostelTranslation('MARK_ALL_LEAVE'),
				name : 'markAttendance',
				inputValue : 'LEAVE',
			},{
				boxLabel : getHostelTranslation('MARK_ALL_LATE_ARRIVIAL'),
				name : 'markAttendance',
				inputValue : 'LATE_ARRIVAL',
				style: {
					'margin-right': '0px !important;'
				}
			}]
	}],
	columns: [{
		header : getHostelTranslation('OCCUPANTID'),
		dataIndex : 'occupantId',
		flex:1
	},{
		header : getHostelTranslation('OCCUPANT'),
		dataIndex : 'occupantName',
		flex:1
	},	{
		header : getHostelTranslation('HOSTEL'),
		dataIndex : 'hostel',
		flex:1
	},{
		header : getHostelTranslation('BUILDING'),
		dataIndex : 'building',
		flex:1
	},{
		header : getHostelTranslation('FLOOR'),
		dataIndex : 'floor',
		flex:1
	},{
		header : getHostelTranslation('ROOM_NO'),
		dataIndex : 'roomNo',
		flex:1
	},{
		header : getHostelTranslation('BED_NO'),
		dataIndex : 'bedNo',
		flex:1
	},{
		xtype : 'checkcolumn', 
		flex:1,
		itemId:'presentId',
		text : getProgramandcourseTranslation('PRESENT'), 
		dataIndex : 'present',
	},{
		xtype : 'checkcolumn',
		text : getProgramandcourseTranslation('ABSENT'),
		dataIndex :  'absent',
		flex : 1
	},{
		header : getProgramandcourseTranslation('OTHERS'),
		dataIndex : 'attendanceStatus',
		flex : 1,
		editor : {
			xtype: 'customcombobox',
			itemId:'attendanceStatusId',
			store:'hostel.hostelattendance.HostelMarkAttendanceStatus',
			valueField : 'value',
			displayField : 'value',
			typeAhead:false,
			editable : false
		}
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			edit: function(obj, editor, context){
				var this$= this;
				var grid = obj.grid;
				var store = grid.getStore();
				var models = grid.getStore().getRange();
				for(var i =0; i<store.data.length;i++){
					if(editor.rowIdx==i){
						models[i].set('present', false);
						models[i].set('absent', false);
					}
				}
			}
		}
	}]
});