Ext.define('Academia.view.hostel.hostelattendance.HostelMarkAttendanceSearch', {
    extend: 'Ext.form.Panel',
    alias: 'widget.hostelmarkattendancesearch',
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getHostelTranslation('HOSTEL'),
            store : 'hostel.managehostel.hostel.HostelCodeName',
            editable : false,
            allowBlank: false,
            name: 'hostelCodeName',
            itemId: 'hostelCodeName',
            valueField: 'id',
            displayField: 'value'
        },{
            xtype: 'customcombobox',
            fieldLabel: getHostelTranslation('BUILDING'),
            store : 'hostel.managehostel.building.BuildingCodeName',
            editable : false,
            name: 'buildingCodeName',
            itemId: 'buildingCodeName',
            valueField: 'id',
            displayField: 'value'
        },{
            xtype: 'customcombobox',
            name: 'floorCodeNo',
            itemId: 'floorCodeNo',
            store:'hostel.managehostel.floor.FloorCodeName',
            fieldLabel: getHostelTranslation('FLOOR'),
            editable: false,
            displayField: 'value',
            valueField: 'id',
        }]
    },{ 
			xtype : 'fieldcontainer',
			width: '100%',
			layout:'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getHostelTranslation('DATE'),
				name : 'date',
				itemId:'date',
//				value : new Date(),
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange',
				allowBlank:false,
				maxValue: new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype : 'timefield',
				name : 'fromTime',		
				itemId : 'fromTime',			
				fieldLabel:getHostelTranslation('TIME'),
				format:'g:i A',
				allowBlank:false,
				vtype: 'timerange'
			}]
		},{
        	xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SEARCH'),
				itemId : 'searchButtonId',
				//buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				formBind:true,
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'resetButtonId',
				//buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
       }]
		
});
