/**
 * Dharmendra.p 
 */
Ext.define('Academia.view.hostel.managehostel.room.EditRoomDetails',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.editroomdetails',
	autoScroll : true,
	frame:true,
	modal : true,
	title : getHostelTranslation('EDIT_ROOM_DETAILS'),
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
	style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    cls:'x-form-fixed-footer-parent',
	items : [{
		xtype:'hidden',
		name:'id'
	},{
		xtype:'hidden',
		name:'isActiveFirstTime',
		itemId:'isActiveFirstTime'
	},{
		xtype:'hidden',
		name:'bedDetailsUpdateIds',
		itemId:'bedDetailsUpdateIds'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			itemId:'hostelCodeName',
			name : 'hostelCodeName',
			fieldLabel : getHostelTranslation('HOSTEL_CODE_NAME'),
 			readOnly : true
		},{
			xtype : 'textfield',
			itemId:'buildingCodeName',
			name : 'buildingCodeName',
			fieldLabel : getHostelTranslation('BUILDING_CODE_NAME'),
 			readOnly : true
		
		},{
			xtype : 'textfield',
			itemId:'floorNo',
			name : 'floorNo',
			readOnly : true,
			fieldLabel : getHostelTranslation('FLOOR_NO')
		
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			itemId: 'roomNumber',
			name : 'roomNumber',
			readOnly : true,
			fieldLabel : getHostelTranslation('ROOM_NO')
		},{
			xtype : 'customcombobox',
			name : 'roomType',
			itemId : 'roomType',
			fieldLabel : getHostelTranslation('ROOM_TYPE'),
//			store : 'hostel.manageroomtype.RoomType',
			store : 'hostel.manageroomtype.ActiveRoomType',
			valueField : 'id',
			displayField : 'roomType',
			allowBlank:false,
			editable : false
		},{
			xtype : 'numberfield',
			itemId: 'numberOfBeds',
			name : 'numberOfBeds',
			allowBlank:false,
			readOnly:true,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowExponential:false,
//			minValue:1,
			fieldLabel : getHostelTranslation('TOTAL_NO_OF_BED')
		}]
	},{
		xtype:'displayfield',
		value:'<b class="menu-title">'+getHostelTranslation('BED_DETAILS')+'</b>',
		style: {
			textDecoration: "underline"
		}
	},{
		xtype:'fieldcontainer',
		itemId:'bedDetailsContainer',
		style:{
			marginLeft:'0px'
		},
		layout : 'vbox',
		items:[{
			xtype : 'fieldcontainer',
//			itemId:'bedDetails',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},style:{
				marginLeft:'0px'
			},
			items : [{
				xtype : 'textfield',
				name : 'bedNo',		
				itemId : 'bedNo',
				allowBlank:false,
				maskRe: /[A-Za-z0-9\s]/,
				fieldLabel:getHostelTranslation('BED_NO')
			},{
				xtype : 'textfield',
				name : 'bedDetails',		
				itemId : 'bedDetails',
				maskRe: /[A-Za-z0-9\s]/,
				fieldLabel:getHostelTranslation('BED_DETAILS')
			},{
                xtype: 'customcombobox',
                fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
                name: 'seatType',
                itemId: 'seatType',
                editable: false,
                store: Ext.create('Academia.store.hostel.managehostel.room.RoomDetailSeatTypeStore'),
                valueField: 'id',
                displayField: 'value',
                //queryMode : 'local'
            },{
				xtype: 'button',
				itemId: 'bedDetailsBtn',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				style:{
					marginTop:'24px'
				}
			/*  listeners:{
				   click:function(obj){
					   var container = obj.up('fieldcontainer');
					   var panelContiner = $this.getStudentattendance().down('#panelId');
					   panelContiner.remove(container);
					   $this.getStudentattendance().isValid();
				   }
			   }*/
			}]
		}]},{
        xtype: 'fieldcontainer',
        labelAlign: 'top',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [ {
			xtype : 'customcombobox',
			name : 'restrictionType',
			itemId : 'restrictionType',
			fieldLabel : getHostelTranslation('RESTRICTION_TYPE'),
			store : 'hostel.managehostel.hostel.RestrictionType',
			valueField : 'id',
			displayField : 'value',
			editable : false
			}]
    },{
        xtype: 'fieldcontainer',
        labelAlign: 'top',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [ {
			xtype : 'customcombobox',
			name : 'status',
			itemId : 'status',
			fieldLabel : getHostelTranslation('STATUS'),
			store : 'hostel.managehostel.room.RoomDetailsStatus',
			valueField : 'id',
			displayField : 'value',
			editable : false
			},{
				xtype : 'datefield',
				name : 'statusChangeDate',
				itemId : 'statusChangeDate',
				fieldLabel : getHostelTranslation('STATUS_CHANGE_DATE'),
				//--submitFormat : CONSTANTS.DATE_FORMAT,
//				value:new Date(),
				allowBlank:false,
				vtype : 'daterange',
				hidden:true,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype : 'customcombobox',
				name : 'statusChangeReason',
				itemId : 'statusChangeReason',
				fieldLabel : getHostelTranslation('STATUS_CHANGE_REASON'),
				store : 'hostel.managehostel.room.StatusChangeReason',
				valueField : 'id',
				displayField : 'value',
				editable : false,
				hidden:true
				}]
    },{
		xtype : 'fieldcontainer',
		width: '100%',
//		layout:'hbox',
		itemId:'dateContainer',
		hidden:true,
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype:'displayfield',
			value:'<b class="menu-title">'+getHostelTranslation('TEMPORARILY_INACTIVE')+'</b>',
			style: {
				textDecoration: "underline"
			}
		},{ 
			xtype : 'fieldcontainer',
			width: '100%',
			layout:'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
			xtype : 'datefield',
			fieldLabel : getProgramandcourseTranslation('START_DATE'),
			name : 'fromDate',
			itemId:'fromDate',
			endDateField : 'toDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange'
		},{
			xtype : 'datefield',
			fieldLabel :getProgramandcourseTranslation('END_DATE'),
			name : 'toDate',
			itemId : 'toDate',
			startDateField : 'fromDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange'
		}]
	}
    ]},{
            xtype: 'fieldcontainer',
            labelAlign: 'top',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 452
            },
            items: [ {
                xtype: 'textarea',
                fieldLabel: getHostelTranslation('REMARKS'), 
                name: 'remarks',
                itemId: 'remarks'
    		}]
        },{
		xtype:'fieldcontainer',
		width:'100%',
		layout : {
			type : 'hbox'
		},
		cls:'form-fixed-footer',
		items : [{
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'saveBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}/*,{
			xtype : 'button',
			text : getCommonTranslation('CANCEL'),
			itemId : 'cancelBtn',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}*/]
	} ]
});