/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.managehostel.room.ManageRoomDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.manageroomdetailsgrid',
	store : 'hostel.managehostel.room.ManageRoomDetails',
	title: getHostelTranslation('LIST_OF_ROOMS'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'managehostelstructurenew':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.managehostel.room.ManageRoomDetails',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getHostelTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getHostelTranslation('VIEW'),
		iconCls: 'view-icon'
	}],
	columns: [{
		header : getHostelTranslation('HOSTEL_CODE_NAME'),
		dataIndex : 'hostelCodeName',
		flex:1,
		 renderer:function(value,record){
			 var hostelCodeName='';
			 if(!isNullOrEmpty(record.record.get("hostelCode") )){
				 var hostelCode = record.record.get("hostelCode");
				 var hostelName = record.record.get("hostelName");
				 hostelCodeName = hostelCode+ '/' +hostelName;
			 }
			 return  hostelCodeName;			 
		}
	},{
		header : getHostelTranslation('BUILDING_CODE_NAME'),
		dataIndex : 'buildingCode',
		flex:1,
		 renderer:function(value,record){
			 var buildingCodeName='';
			 if(!isNullOrEmpty(record.record.get("buildingCode") )){
				 var buildingCode = record.record.get("buildingCode");
				 var buildingName = record.record.get("buildingName");
				 buildingCodeName = buildingCode+ '/' +buildingName;
			 }
			 return  buildingCodeName;			 
		}
	},{
		header : getHostelTranslation('FLOOR_NO'),
		dataIndex : 'floorNo',
		flex:1
	},{
		header : getHostelTranslation('ROOM_NO'),
		dataIndex : 'roomNo',
		flex:1
	},{
		header : getHostelTranslation('ROOM_TYPE'),
		dataIndex : 'roomType',
		flex:1
	},{
		header : getHostelTranslation('TOTAL_NO_OF_BEDS'),
		dataIndex : 'noOfBeds',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else if(value == 'INACTIVE' || value == 'Inactive'){
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				}else if(value == 'TEMPORARY_INACTIVE' || value == 'Temporary Inactive'){
					return '<span style="color:red;">' + getHostelTranslation('TEMPORARY_INACTIVE') + '</span>';
				} 
			}
		}
	}]
});