/**
 *  @author Sohan Chouhan
 */
Ext.define('Academia.view.hostel.reports.hosteldetailreport.HostelDetailsReportSearch', {
	extend: 'Ext.form.Panel',
	alias: 'widget.hosteldetailsreportsearch',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'customcombobox',
			name:'userType',
			itemId:'userType',
			store:'attendance.UserGroup',
			fieldLabel: getHostelTranslation('USER_TYPE'),
			valueField: 'id',
			displayField: 'userGroupName',
			typeAhead:false,
			editable: false
		}, {
			xtype: 'customcombobox',
			name: 'studentName',
			itemId: 'studentName',
			fieldLabel: getHostelTranslation('NAME'),
			store: Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			store:'common.AcademicTermStore',
			editable: false,
			forceSelection : true,
			hidden : false
		}]
	},{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getHostelTranslation('MORE_FILTERS'),
		titleCollapse: true,
		width:'100%',
		style: {
			marginTop: '40px!important'
		},
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [ {
				xtype: 'customcombobox',
				fieldLabel: getHostelTranslation('ACADEMY_LOCATION'),
				width: 536,
				store : 'user.UserAcademyLocationStore',
				name: 'academyLocation',
				itemId: 'academyLocation',
				valueField: 'id',
				displayField: 'value',
				typeAhead: true,
				forceSelection: true,
				triggerAction: 'all',
				minChars:3,
				queryParam:'qry',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR')
			},{
				xtype: 'customcombobox',
				fieldLabel: getHostelTranslation('HOSTEL_CODE_NAME'),
				store : 'hostel.managehostel.hostel.ManageHostelCodeName',
				editable : false,
				name: 'hostelCodeName',
				itemId: 'hostelCodeName',
				valueField: 'id',
				displayField: 'value'
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getHostelTranslation('BUILDING_CODE_NAME'),
				store : 'hostel.managehostel.building.ManageBuildingCodeName',
				editable : false,
				name: 'buildingCodeName',
				itemId: 'buildingCodeName',
				valueField: 'id',
				displayField: 'value'
			},{
				xtype: 'customcombobox',
				name: 'floorCodeNo',
				itemId: 'floorCodeNo',
				store:'hostel.managehostel.floor.ManageFloorCodeName',
				fieldLabel: getHostelTranslation('FLOOR_NO'),
				editable: false,
				displayField: 'value',
				valueField: 'id',
			},/*{

				xtype: 'customcombobox',
				name: 'SPONSOR_ID',
				itemId: 'sponMaster_sponId',
				fieldLabel: getCommonTranslation('SPONSOR_CODE_NAME'),
				store:'sponsorship.SponsorsNameCodeStore',
				valueField: 'id',
				displayField: 'value',
				queryParam:'sponsorNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{sponsorshipCode} / {sponsorshipName}' +
						'</div>';
					}
				}
			}*/]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getHostelTranslation('ROOM_NO'),
				store : 'hostel.managehostel.floor.RoomCodeName',
				editable : false,
				name: 'roomNo',
				itemId: 'roomNo',
				valueField: 'id',
				displayField: 'value'
			},{
				xtype: 'customcombobox',
				name: 'status',
				itemId: 'status',
				fieldLabel: getHostelTranslation('STATUS'),
				valueField: 'code',
				editable : false,
				displayField: 'value',
				typeAhead: true,
				forceSelection: true,
				store: {
					fields: [ 'value', 'code'],
					data : [
						{"value":"Active", "code": "ACTIVE"},
						{"value":"Inactive", "code": "INACTIVE"},
						]
				}
			}]
		},{ 
			xtype : 'fieldcontainer',
			width: '100%',
			layout:'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel: getCommonTranslation('START_DATE'),
				name : 'fromDate',
				itemId:'fromDate',
				endDateField : 'toDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				fieldLabel: getProgramandcourseTranslation('END_DATE'),
				name : 'toDate',
				itemId : 'toDate',
				startDateField : 'fromDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
			}]
		}
		]             
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchButtonId',
			//buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButtonId',
			//buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}]
});
