/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.reports.hostelfeereports.HostelFeeReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.hostelfeereportgrid',
	store :'hostel.reports.hostelfeereport.HostelFeeReportGridStr',
	title: getHostelTranslation('LIST_OF_ROOMS'),
	border: true,
	refreshStoreData:true,
	//enableColumnHide : false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.reports.hostelfeereport.HostelFeeReportGridStr',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	columns: [{
		header : getHostelTranslation('ADMISSIONID'),
		dataIndex : 'admissionCode',
		flex:1,
		hidden:true
	},{
		header : getHostelTranslation('OCCUPANTID'),
		dataIndex : 'occupantId',
		flex:1
	},{
		header : getHostelTranslation('OCCUPANT_NAME'),
		dataIndex : 'occupantName',
		flex:1,
		/*renderer:function(value){
			if(!isNullOrEmpty(value)){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}*/
	},{
		text : getHostelTranslation('CITY'),
		dataIndex : 'city',
		hidden:true,
		flex:1		
	},{
		header : getHostelTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocation',
		flex:1
	},{
		text : getHostelTranslation('PROGRAM'),
		dataIndex : 'programName',
		hidden:true,
		flex:1		
	},{
		text : getHostelTranslation('BATCH'),
		dataIndex : 'batchName',
		hidden:true,
		flex:1
	},{
		header : getHostelTranslation('HOSTEL_NAME'),
		dataIndex : 'hostelCode',
		flex:1
	},{
		header : getHostelTranslation('BUILDING_NAME'),
		dataIndex : 'buildingCode',
		flex:1.2
	},{
		header : getHostelTranslation('FLOOR_NO'),
		dataIndex : 'floorCode',
		flex:1
	},{
		header : getHostelTranslation('ROOM_NO'),
		dataIndex : 'roomNo',
		flex:1
	},{
		header : getHostelTranslation('ROOM_TYPE'),
		dataIndex : 'roomType',
		flex:1
	},{
		header : getHostelTranslation('BILL_ID'),
		itemId:'billId',
		dataIndex : 'billId',
		hidden:true,
		flex:1
	},{
		header : getHostelTranslation('BILL_DATE'),
		itemId:'billDate',
		dataIndex : 'billDate',
		hidden:true,
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getHostelTranslation('RECEIPT_NO'),
		itemId : 'receiptNo',
		dataIndex : 'receiptNo',
		hidden:true,
		flex:1
	},{
		header : getHostelTranslation('RECEIPT_DATE'),
		itemId : 'receiptDate',
		dataIndex : 'receiptDate',
		hidden:true,
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getHostelTranslation('PAYMENT_VOUCHER_NO'),
		itemId : 'paymentVoucherNo',
		dataIndex : 'paymentVoucherNo',
		hidden:true,
		flex:1
	},{
		header : getHostelTranslation('PAYMENT_DATE'),
		itemId : 'paymentDate',
		dataIndex : 'paymentDate',
		hidden:true,
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getHostelTranslation('HOSTEL_CURRENCY_EXCHANGE_RATE'),
		dataIndex : 'currencyExchangeRate',
		//itemId : 'totalAmount',
		flex:1,
		/*renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}*/
	},{
		header : getHostelTranslation('TOTAL_AMOUNT'),
		dataIndex : 'totalAmount',
		itemId : 'totalAmount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getHostelTranslation('CONVERTED_TOTAL_AMOUNT'),
		dataIndex : 'currencyTotalAmount',
		//itemId : 'totalAmount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if (!isNullOrEmpty(record.raw.baseCurrencyId)) {
				if (!isNullOrEmpty(value)) {
					return currencyRenderer(value,
							record.raw.baseCurrencyId);
				} else {
					return "";
				}
			}
		}
	},{
		header : getHostelTranslation('OUTSTANDING_AMOUNT'),
		itemId : 'outstandingAmount',
		dataIndex : 'outstandingAmount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getHostelTranslation('CONVERTED_OUTSTANDING_AMOUNT'),
		dataIndex : 'currencyOutstandingAmount',
		//itemId : 'totalAmount',
		flex:1,
		renderer : function(value, metaData, record,
				row, col, store, gridView) {
			if (!isNullOrEmpty(record.raw.baseCurrencyId)) {
				if (!isNullOrEmpty(value)) {
					return currencyRenderer(value,
							record.raw.baseCurrencyId);
				} else {
					return "";
				}
			}
		}
	},{
		header : getHostelTranslation('SETTLED_AMOUNT'),
		itemId : 'settledAmount',
		dataIndex : 'settledAmount',
		hidden:true,
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('BILL_DETAILS'),
		dataIndex : 'billDetails',
		itemId : 'billDetails',
		flex : 1,
		renderer : function(value){
			return  '<a href="#">'+"View"+'</a>';
		}
	},{
		header : getFeeAndPaymentCommonTranslation('RECEIPT_DETAILS'),
		dataIndex : 'receiptDetails',
		itemId : 'receiptDetails',
		hidden:true,
		flex : 1,
		renderer : function(value){
			return  '<a href="#">'+"View"+'</a>';
		}
	}]
});