/**
 * Dharmendra.prajapati
 */

Ext.define('Academia.view.hostel.roomallocation.userwise.CancelAllotmentWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.cancelallotmentwin',
	title:getHostelTranslation('CANCEL_ALLOTMENT'),
	frame: true,
	autoScroll:true,
	modal:true, 
	method: 'POST',
//	maxHeight: 600,
	height: '80%',
	width: '60%',
	items: [{
		xtype: 'form',
		method: 'POST',
//		margin: 0,
		standardSubmit: false,
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype:'displayfield',
				name : 'hostelName',
				itemId : 'hostelName',
				fieldLabel: getHostelTranslation('HOSTEL_NAME')
			},{
				xtype:'displayfield',
				name : 'roomType',
				itemId : 'roomType',
				fieldLabel: getHostelTranslation('ROOM_TYPE')
			},{
				xtype:'displayfield',
				name : 'roomNo',
				itemId : 'roomNo',
				fieldLabel: getHostelTranslation('ROOM_NO')
			}]
		},{
			xtype:'cancelallotmentlist',
			itemId:'cancelallotmentlist',
			style:{
				marginLeft:'0px'
			}	
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'datefield',
				name : 'cancelDate',
				itemId : 'cancelDate',
				fieldLabel : getHostelTranslation('CANCEL_DATE'),
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
//				value:new Date(),
				allowBlank:false,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype: 'customcombobox',
				fieldLabel : getHostelTranslation('CANCELLATION_BY'),
				name:'cancellationBy',
				itemId:'cancellationBy',
				store: 'criteriabuilder.userquicksearch.QuickSearchName',
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					 listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						}, 
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}},{
					xtype : 'customcombobox',
					name : 'cancellationReason',
					itemId : 'cancellationReason',
					store: 'hostel.roomallocation.userwise.CancellationReasonCombo',
					valueField: 'id',
					displayField: 'value', 
					editable: false,
					fieldLabel : getHostelTranslation('CANCELLATION_REASON'),

				}]
		},/*{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'combo',
				name : 'cancellationReason',
				itemId : 'cancellationReason',
				store: 'hostel.roomallocation.userwise.CancellationReasonCombo',
				valueField: 'id',
				displayField: 'value', 
				editable: false,
				fieldLabel : getHostelTranslation('CANCELLATION_REASON'),

			}
			]},*/{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
				},
				items:[{
					xtype: 'textarea',
			        name: 'remarks',
			        itemId: 'remarks',
			        fieldLabel: getCommonTranslation('REMARKS'),
			        width: 536
			        }
				]},{
			xtype:'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'submitBtn',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				formBind : true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel', 
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE

			}]
		}]
	}]     
});
