/**
 * Dharmendra.prajapati
 */

Ext.define('Academia.view.hostel.roomallocation.userwise.CheckOutWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.checkoutwin',
	title:getHostelTranslation('CHECK_OUT'),
	frame: true,
	autoScroll:true,
	modal:true, 
	method: 'POST',
//	maxHeight: 600,
	height: '80%',
	width: '60%',
	items: [{
//		xtype: 'form',
		method: 'POST',
		xtype: 'idgeneratorformwin',
		itemId:'checkoutwin',
		standardSubmit: false,
		plugins : "formlabelrequired",
//		margin: 0,
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:275
			},
			/*items:[{
				xtype:'displayfield',
				name : 'hostelName',
				itemId : 'hostelName',
				fieldLabel: getHostelTranslation('HOSTEL_NAME')
			},{
				xtype:'displayfield',
				name : 'roomType',
				itemId : 'roomType',
				fieldLabel: getHostelTranslation('ROOM_TYPE')
			},{
				xtype:'displayfield',
				name : 'roomNo',
				itemId : 'roomNo',
				fieldLabel: getHostelTranslation('ROOM_NO')
			}]*/
		},{
			xtype:'cancelallotmentlist',
			itemId:'checkoutwinListItemId',
			style:{
				marginLeft:'0px'
			}	
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'datefield',
				name : 'checkOutDate',
				itemId : 'checkOutDate',
				fieldLabel : getHostelTranslation('CHECK_OUT_DATE'),
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				allowBlank:false,
//				value:new Date(),
				vtype : 'daterange',
				maxValue: new Date(),
//				minValue: new Date(),
				//V2D-293550
				listeners: {
					render: function(obj) {
						if(!isNullOrEmpty(obj)){
							obj = dateFormatRender(obj);						
							obj.setValue(new Date());
							return dateFormatRender(obj);
						}
					}
				}
			},{
				xtype: 'customcombobox',
				fieldLabel : getHostelTranslation('KEY_RETURNED_TO'),
				name:'keyReturnedTo',
				itemId:'keyReturnedTo',
				store: 'criteriabuilder.userquicksearch.QuickSearchName',
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
//				allowBlank: false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					 listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}},{
					xtype: 'customcombobox',
					name: 'checkOutReason',
					fieldLabel: getHostelTranslation('CHECK_OUT_REASON'),
					store: 'hostel.roomallocation.userwise.CheckOutReasonCombo',
					valueField: 'id',
					editable:false,
					displayField: 'value'
				}]
		},{


			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'datefield',
				name : 'financialActualCheckOutDate',
				itemId : 'financialActualCheckOutDate',
				fieldLabel : getHostelTranslation('FINANCIAL_ACTUAL_CHECK_OUT_DATE'),
				listeners: {
					render: function(field) {
						field = dateFormatRender(field);						
						field.setValue(new Date());
					}
				},
				editable:false,
			},{
				xtype: 'numberfield',
				fieldLabel: getHostelTranslation('CHECK_OUT_NUMBER_OF_DAYS'),
				name: 'checkOutNumberOfDays',
				itemId:'checkOutNumberOfDays',
				readOnly:true,
			},{
				xtype: 'numberfield',
				fieldLabel: getHostelTranslation('CHECK_OUT_AMOUNT_TO_BE_PAID'),
				name: 'checkOutAmountToBePaid',
				itemId:'checkOutAmountToBePaid',
			}]
		
		
		}, {
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width: 256
				},
				items:[{
		        	xtype: 'textareafield',
					name: 'checkOutRemark',
					maxLength : 1500,
		            enforceMaxLength : true,
					fieldLabel:getHostelTranslation('REMARKS'),
					width: 536
		        }]
			},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			items:[{
	    		xtype: 'checkboxfield',
	    		boxLabel:getHostelTranslation('SERVICE_OPT_OUT_REQUIRED'),
	    		name:'isServiceOptOutRequired',
	    		itemId:'isServiceOptOutRequiredId'
	    	},{
	    		xtype: 'checkboxfield',
	    		boxLabel:getHostelTranslation('PENALTY_FEE_APPLICABLE'),
	    		name:'penaltyFeeApplicable',
	    		itemId:'penaltyFeeApplicableId'
	    	}]
		},/*{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'combo',
				name: 'checkOutReason',
				fieldLabel: getHostelTranslation('CHECK_OUT_REASON'),
				store: 'hostel.roomallocation.userwise.CheckOutReasonCombo',
				valueField: 'id',
				editable:false,
				displayField: 'value'
			}
			]},*/{
			xtype:'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'submitBtn',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				formBind : true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel', 
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE

			}]
		}]
	}]     
});
