/**
 * Dharmendra.prajapati
 */

Ext.define('Academia.view.hostel.roomallocation.userwise.UserAllotRoomWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.userallotroomwin',
	title:getHostelTranslation('ALLOT_ROOM'),
	frame: true,
	autoScroll:false,
	modal:true, 
	method: 'POST',
//	maxHeight: 600,
	height: '45%',
	width: '80%',
	items: [{
		xtype: 'form',
		method: 'POST',
		standardSubmit: false,
		plugins : "formlabelrequired",
//		margin: 0,
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype:'displayfield',
				name : 'userName',
				itemId : 'userName',
				fieldLabel: getHostelTranslation('USER_NAME')
			},{
				xtype:'displayfield',
				name : 'hostelName',
				itemId : 'hostelName',
				fieldLabel: getHostelTranslation('HOSTEL_NAME')
			},{
				xtype:'displayfield',
				name : 'roomType',
				itemId : 'roomType',
				fieldLabel: getHostelTranslation('ROOM_TYPE')
			},{
				xtype:'displayfield',
				name : 'roomNo',
				itemId : 'roomNo',
				fieldLabel: getHostelTranslation('ROOM_NO')
			}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'datefield',
				name : 'allotmentDate',
				itemId : 'allotmentDate',
				fieldLabel : getHostelTranslation('ALLOTMENT_DATE'),
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
//				value:new Date(),
				allowBlank:false,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
						var currentYear = new Date().getFullYear();
						var minDate = '01/01/'+currentYear;
						var maxDate = '31/12/'+currentYear;
						obj.setMinValue(minDate);
						obj.setMaxValue(maxDate);
					}
				}
			},{
				xtype: 'combo',
				fieldLabel : getHostelTranslation('ALLOTMENT_BY'),
				name:'allotmentBy',
				itemId:'allotmentBy',
				store: 'criteriabuilder.userquicksearch.QuickSearchName',
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				allowBlank: false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}},{
					xtype: 'combo',
					fieldLabel : getHostelTranslation('CREATED_BY'),
					name:'createdBy',
					itemId:'createdBy',
					store: 'criteriabuilder.userquicksearch.QuickSearchName',
					msgTarget: 'qtip',
					valueField: 'id',
					displayField: 'value',
					queryParam:'name',
					minChars:3,
//					allowBlank: false,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}},{
				xtype: 'customcombobox',
				name: 'roomAllotAdmissionCode',
				itemId: 'roomAllotAdmissionCodeId',
				fieldLabel: getCommonTranslation('ADMISSION_ID'),
				store:'hostel.roomallocation.AdmissionByStudentIdStore',
				displayField:'code',
				valueField:'id',
				allowBlank: false,
				forceSelection:true
            }]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			/*defaults: {
				labelAlign:'top',
				width: 256
			},*/
			items:[{
				xtype:'displayfield',
				name : 'inactiveStatusMsg',
				itemId : 'inactiveStatusMsg'
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'submitBtn',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				formBind : true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel', 
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE

			}]
		}]
	}]     
});
